/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.format.support;

import cn.taketoday.core.conversion.Converter;
import cn.taketoday.core.io.DefaultResourceLoader;
import cn.taketoday.core.io.Resource;
import cn.taketoday.core.io.ResourceLoader;
import cn.taketoday.util.ResourceUtils;
import java.io.File;
import java.io.IOException;

class StringToFileConverter
implements Converter<String, File> {
    private static final ResourceLoader resourceLoader = new DefaultResourceLoader(null);

    StringToFileConverter() {
    }

    public File convert(String source) {
        if (ResourceUtils.isUrl((String)source)) {
            return this.getFile(resourceLoader.getResource(source));
        }
        File file = new File(source);
        if (file.exists()) {
            return file;
        }
        Resource resource = resourceLoader.getResource(source);
        if (resource.exists()) {
            return this.getFile(resource);
        }
        return file;
    }

    private File getFile(Resource resource) {
        try {
            return resource.getFile();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Could not retrieve file for " + resource + ": " + ex.getMessage());
        }
    }
}

