/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.format.support;

import cn.taketoday.core.TypeDescriptor;
import cn.taketoday.core.conversion.GenericConverter;
import cn.taketoday.format.annotation.DataSizeUnit;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.DataSize;
import cn.taketoday.util.DataUnit;
import cn.taketoday.util.ObjectUtils;
import java.util.Collections;
import java.util.Set;

final class StringToDataSizeConverter
implements GenericConverter {
    StringToDataSizeConverter() {
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(String.class, DataSize.class));
    }

    @Nullable
    public Object convert(@Nullable Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (ObjectUtils.isEmpty((Object)source)) {
            return null;
        }
        return this.convert(source.toString(), this.getDataUnit(targetType));
    }

    @Nullable
    private DataUnit getDataUnit(TypeDescriptor targetType) {
        DataSizeUnit annotation = (DataSizeUnit)targetType.getAnnotation(DataSizeUnit.class);
        return annotation != null ? annotation.value() : null;
    }

    private DataSize convert(String source, @Nullable DataUnit unit) {
        return DataSize.parse((CharSequence)source, (DataUnit)unit);
    }
}

