/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.format.support;

import cn.taketoday.core.TypeDescriptor;
import cn.taketoday.core.conversion.GenericConverter;
import cn.taketoday.format.annotation.PeriodFormat;
import cn.taketoday.format.annotation.PeriodStyle;
import cn.taketoday.format.annotation.PeriodUnit;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ObjectUtils;
import java.time.Period;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Set;

final class PeriodToStringConverter
implements GenericConverter {
    PeriodToStringConverter() {
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Period.class, String.class));
    }

    @Nullable
    public Object convert(@Nullable Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (ObjectUtils.isEmpty((Object)source)) {
            return null;
        }
        return this.convert((Period)source, this.getPeriodStyle(sourceType), this.getPeriodUnit(sourceType));
    }

    @Nullable
    private PeriodStyle getPeriodStyle(TypeDescriptor sourceType) {
        PeriodFormat annotation = (PeriodFormat)sourceType.getAnnotation(PeriodFormat.class);
        return annotation != null ? annotation.value() : null;
    }

    private String convert(Period source, @Nullable PeriodStyle style, @Nullable ChronoUnit unit) {
        style = style != null ? style : PeriodStyle.ISO8601;
        return style.print(source, unit);
    }

    @Nullable
    private ChronoUnit getPeriodUnit(TypeDescriptor sourceType) {
        PeriodUnit annotation = (PeriodUnit)sourceType.getAnnotation(PeriodUnit.class);
        return annotation != null ? annotation.value() : null;
    }
}

