/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.format.support;

import cn.taketoday.core.conversion.Converter;
import cn.taketoday.core.conversion.ConverterFactory;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.DefaultMultiValueMap;
import cn.taketoday.util.MultiValueMap;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;

abstract class LenientObjectToEnumConverterFactory<T>
implements ConverterFactory<T, Enum<?>> {
    private static final Map<String, List<String>> ALIASES;

    LenientObjectToEnumConverterFactory() {
    }

    public <E extends Enum<?>> Converter<T, E> getConverter(Class<E> targetType) {
        Class<E> enumType;
        for (enumType = targetType; enumType != null && !enumType.isEnum(); enumType = enumType.getSuperclass()) {
        }
        if (enumType == null) {
            throw new IllegalArgumentException("The target type " + targetType.getName() + " does not refer to an enum");
        }
        return new LenientToEnumConverter<E>(enumType);
    }

    static {
        DefaultMultiValueMap aliases = MultiValueMap.fromLinkedHashMap();
        aliases.add((Object)"true", (Object)"on");
        aliases.add((Object)"false", (Object)"off");
        ALIASES = Collections.unmodifiableMap(aliases);
    }

    private class LenientToEnumConverter<E extends Enum>
    implements Converter<T, E> {
        private final Class<E> enumType;

        LenientToEnumConverter(Class<E> enumType) {
            this.enumType = enumType;
        }

        @Nullable
        public E convert(T source) {
            String value = source.toString().trim();
            if (value.isEmpty()) {
                return null;
            }
            try {
                return Enum.valueOf(this.enumType, value);
            }
            catch (Exception ex) {
                return this.findEnum(value);
            }
        }

        private E findEnum(String value) {
            String name = this.getCanonicalName(value);
            List aliases = ALIASES.getOrDefault(name, Collections.emptyList());
            for (Enum candidate : EnumSet.allOf(this.enumType)) {
                String candidateName = this.getCanonicalName(candidate.name());
                if (!name.equals(candidateName) && !aliases.contains(candidateName)) continue;
                return (E)candidate;
            }
            throw new IllegalArgumentException("No enum constant " + this.enumType.getCanonicalName() + "." + value);
        }

        private String getCanonicalName(String name) {
            StringBuilder canonicalName = new StringBuilder(name.length());
            name.chars().filter(Character::isLetterOrDigit).map(Character::toLowerCase).forEach(c -> canonicalName.append((char)c));
            return canonicalName.toString();
        }
    }
}

