/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.format.support;

import cn.taketoday.core.conversion.Converter;
import cn.taketoday.core.io.InputStreamSource;
import cn.taketoday.core.io.Resource;
import cn.taketoday.util.FileCopyUtils;
import java.io.IOException;
import java.io.InputStream;

class InputStreamSourceToByteArrayConverter
implements Converter<InputStreamSource, byte[]> {
    InputStreamSourceToByteArrayConverter() {
    }

    public byte[] convert(InputStreamSource source) {
        try {
            return FileCopyUtils.copyToByteArray((InputStream)source.getInputStream());
        }
        catch (IOException ex) {
            throw new IllegalStateException("Unable to read from " + this.getName(source), ex);
        }
    }

    private String getName(InputStreamSource source) {
        if (source instanceof Resource) {
            return source.toString();
        }
        return "input stream source";
    }
}

