/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.format.support;

import cn.taketoday.beans.factory.FactoryBean;
import cn.taketoday.beans.factory.InitializingBean;
import cn.taketoday.context.expression.EmbeddedValueResolverAware;
import cn.taketoday.core.StringValueResolver;
import cn.taketoday.core.conversion.ConverterRegistry;
import cn.taketoday.format.AnnotationFormatterFactory;
import cn.taketoday.format.Formatter;
import cn.taketoday.format.FormatterRegistrar;
import cn.taketoday.format.support.DefaultFormattingConversionService;
import cn.taketoday.format.support.FormattingConversionService;
import cn.taketoday.lang.Nullable;
import java.util.Set;

public class FormattingConversionServiceFactoryBean
implements FactoryBean<FormattingConversionService>,
EmbeddedValueResolverAware,
InitializingBean {
    @Nullable
    private Set<?> converters;
    @Nullable
    private Set<?> formatters;
    @Nullable
    private Set<FormatterRegistrar> formatterRegistrars;
    private boolean registerDefaultFormatters = true;
    @Nullable
    private StringValueResolver embeddedValueResolver;
    @Nullable
    private FormattingConversionService conversionService;

    public void setConverters(Set<?> converters) {
        this.converters = converters;
    }

    public void setFormatters(Set<?> formatters) {
        this.formatters = formatters;
    }

    public void setFormatterRegistrars(Set<FormatterRegistrar> formatterRegistrars) {
        this.formatterRegistrars = formatterRegistrars;
    }

    public void setRegisterDefaultFormatters(boolean registerDefaultFormatters) {
        this.registerDefaultFormatters = registerDefaultFormatters;
    }

    @Override
    public void setEmbeddedValueResolver(StringValueResolver embeddedValueResolver) {
        this.embeddedValueResolver = embeddedValueResolver;
    }

    public void afterPropertiesSet() {
        this.conversionService = new DefaultFormattingConversionService(this.embeddedValueResolver, this.registerDefaultFormatters);
        ConverterRegistry.registerConverters(this.converters, (ConverterRegistry)this.conversionService);
        this.registerFormatters(this.conversionService);
    }

    private void registerFormatters(FormattingConversionService conversionService) {
        if (this.formatters != null) {
            for (Object formatter : this.formatters) {
                if (formatter instanceof Formatter) {
                    conversionService.addFormatter((Formatter)formatter);
                    continue;
                }
                if (formatter instanceof AnnotationFormatterFactory) {
                    conversionService.addFormatterForFieldAnnotation((AnnotationFormatterFactory)formatter);
                    continue;
                }
                throw new IllegalArgumentException("Custom formatters must be implementations of Formatter or AnnotationFormatterFactory");
            }
        }
        if (this.formatterRegistrars != null) {
            for (FormatterRegistrar registrar : this.formatterRegistrars) {
                registrar.registerFormatters(conversionService);
            }
        }
    }

    @Nullable
    public FormattingConversionService getObject() {
        return this.conversionService;
    }

    public Class<? extends FormattingConversionService> getObjectType() {
        return FormattingConversionService.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

