/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.format.support;

import cn.taketoday.context.expression.EmbeddedValueResolverAware;
import cn.taketoday.core.DecoratingProxy;
import cn.taketoday.core.GenericTypeResolver;
import cn.taketoday.core.StringValueResolver;
import cn.taketoday.core.TypeDescriptor;
import cn.taketoday.core.conversion.ConditionalGenericConverter;
import cn.taketoday.core.conversion.ConversionService;
import cn.taketoday.core.conversion.GenericConverter;
import cn.taketoday.core.conversion.support.GenericConversionService;
import cn.taketoday.core.i18n.LocaleContextHolder;
import cn.taketoday.format.AnnotationFormatterFactory;
import cn.taketoday.format.Formatter;
import cn.taketoday.format.FormatterRegistry;
import cn.taketoday.format.Parser;
import cn.taketoday.format.Printer;
import cn.taketoday.lang.NonNull;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.util.StringUtils;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class FormattingConversionService
extends GenericConversionService
implements FormatterRegistry,
EmbeddedValueResolverAware {
    @Nullable
    private StringValueResolver embeddedValueResolver;
    private final ConcurrentHashMap<ConverterKey, GenericConverter> cachedParsers = new ConcurrentHashMap(64);
    private final ConcurrentHashMap<ConverterKey, GenericConverter> cachedPrinters = new ConcurrentHashMap(64);

    @Override
    public void setEmbeddedValueResolver(@Nullable StringValueResolver resolver) {
        this.embeddedValueResolver = resolver;
    }

    @Override
    public void addPrinter(Printer<?> printer) {
        Class<?> fieldType = FormattingConversionService.getFieldType(printer, Printer.class);
        this.addConverter(new PrinterConverter(fieldType, printer, (ConversionService)this));
    }

    @Override
    public void addParser(Parser<?> parser) {
        Class<?> fieldType = FormattingConversionService.getFieldType(parser, Parser.class);
        this.addConverter(new ParserConverter(fieldType, parser, (ConversionService)this));
    }

    @Override
    public void addFormatter(Formatter<?> formatter) {
        this.addFormatterForFieldType(FormattingConversionService.getFieldType(formatter), formatter);
    }

    @Override
    public void addFormatterForFieldType(Class<?> fieldType, Formatter<?> formatter) {
        this.addConverter(new PrinterConverter(fieldType, formatter, (ConversionService)this));
        this.addConverter(new ParserConverter(fieldType, formatter, (ConversionService)this));
    }

    @Override
    public void addFormatterForFieldType(Class<?> fieldType, Printer<?> printer, Parser<?> parser) {
        this.addConverter(new PrinterConverter(fieldType, printer, (ConversionService)this));
        this.addConverter(new ParserConverter(fieldType, parser, (ConversionService)this));
    }

    @Override
    public <T extends Annotation> void addFormatterForFieldAnnotation(AnnotationFormatterFactory<T> factory) {
        Class<T> annotationType = FormattingConversionService.getAnnotationType(factory);
        if (this.embeddedValueResolver != null && factory instanceof EmbeddedValueResolverAware) {
            ((EmbeddedValueResolverAware)((Object)factory)).setEmbeddedValueResolver(this.embeddedValueResolver);
        }
        Set<Class<?>> fieldTypes = factory.getFieldTypes();
        for (Class<?> fieldType : fieldTypes) {
            this.addConverter((GenericConverter)new AnnotationPrinterConverter(annotationType, factory, fieldType));
            this.addConverter((GenericConverter)new AnnotationParserConverter(annotationType, factory, fieldType));
        }
    }

    static Class<?> getFieldType(Formatter<?> formatter) {
        return FormattingConversionService.getFieldType(formatter, Formatter.class);
    }

    private static <T> Class<?> getFieldType(T instance, Class<T> genericInterface) {
        Class fieldType = GenericTypeResolver.resolveTypeArgument(instance.getClass(), genericInterface);
        if (fieldType == null && instance instanceof DecoratingProxy) {
            DecoratingProxy decoratingProxy = (DecoratingProxy)instance;
            fieldType = GenericTypeResolver.resolveTypeArgument((Class)decoratingProxy.getDecoratedClass(), genericInterface);
        }
        if (fieldType == null) {
            throw new IllegalArgumentException("Unable to extract the parameterized field type from " + ClassUtils.getShortName(genericInterface) + " [" + instance.getClass().getName() + "]; does the class parameterize the <T> generic type?");
        }
        return fieldType;
    }

    static <T extends Annotation> Class<T> getAnnotationType(AnnotationFormatterFactory<T> factory) {
        Class annotationType = GenericTypeResolver.resolveTypeArgument(factory.getClass(), AnnotationFormatterFactory.class);
        if (annotationType == null) {
            throw new IllegalArgumentException("Unable to extract parameterized Annotation type argument from AnnotationFormatterFactory [" + factory.getClass().getName() + "]; does the factory parameterize the <A extends Annotation> generic type?");
        }
        return annotationType;
    }

    @NonNull
    private static Annotation getAnnotation(TypeDescriptor sourceType, Class<? extends Annotation> annotationType) {
        Annotation ann = sourceType.getAnnotation(annotationType);
        if (ann == null) {
            throw new IllegalStateException("Expected [" + annotationType.getName() + "] to be present on " + sourceType);
        }
        return ann;
    }

    private static class PrinterConverter
    implements GenericConverter {
        private final Class<?> fieldType;
        private final TypeDescriptor printerObjectType;
        private final Printer printer;
        private final ConversionService conversionService;

        public PrinterConverter(Class<?> fieldType, Printer<?> printer, ConversionService conversionService) {
            this.fieldType = fieldType;
            this.printerObjectType = TypeDescriptor.valueOf(this.resolvePrinterObjectType(printer));
            this.printer = printer;
            this.conversionService = conversionService;
        }

        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return Collections.singleton(new GenericConverter.ConvertiblePair(this.fieldType, String.class));
        }

        public Object convert(@Nullable Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            if (!sourceType.isAssignableTo(this.printerObjectType)) {
                source = this.conversionService.convert(source, sourceType, this.printerObjectType);
            }
            if (source == null) {
                return "";
            }
            return this.printer.print(source, LocaleContextHolder.getLocale());
        }

        @Nullable
        private Class<?> resolvePrinterObjectType(Printer<?> printer) {
            return GenericTypeResolver.resolveTypeArgument(printer.getClass(), Printer.class);
        }

        public String toString() {
            return this.fieldType.getName() + " -> " + String.class.getName() + " : " + this.printer;
        }
    }

    private record ParserConverter(Class<?> fieldType, Parser<?> parser, ConversionService conversionService) implements GenericConverter
    {
        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return Collections.singleton(new GenericConverter.ConvertiblePair(String.class, this.fieldType));
        }

        @Nullable
        public Object convert(@Nullable Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            Object result;
            String text = (String)source;
            if (StringUtils.isBlank((String)text)) {
                return null;
            }
            try {
                result = this.parser.parse(text, LocaleContextHolder.getLocale());
            }
            catch (IllegalArgumentException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new IllegalArgumentException("Parse attempt failed for value [" + text + "]", ex);
            }
            TypeDescriptor resultType = TypeDescriptor.valueOf(result.getClass());
            if (!resultType.isAssignableTo(targetType)) {
                result = this.conversionService.convert(result, resultType, targetType);
            }
            return result;
        }

        @Override
        public String toString() {
            return String.class.getName() + " -> " + this.fieldType.getName() + ": " + this.parser;
        }
    }

    private class AnnotationPrinterConverter
    implements ConditionalGenericConverter {
        private final Class<? extends Annotation> annotationType;
        private final AnnotationFormatterFactory formatterFactory;
        private final Class<?> fieldType;

        public AnnotationPrinterConverter(Class<? extends Annotation> annotationType, AnnotationFormatterFactory<?> formatterFactory, Class<?> fieldType) {
            this.fieldType = fieldType;
            this.annotationType = annotationType;
            this.formatterFactory = formatterFactory;
        }

        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return Collections.singleton(new GenericConverter.ConvertiblePair(this.fieldType, String.class));
        }

        public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
            return sourceType.hasAnnotation(this.annotationType);
        }

        @Nullable
        public Object convert(@Nullable Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            Annotation ann = FormattingConversionService.getAnnotation(sourceType, this.annotationType);
            ConverterKey key = new ConverterKey(ann, sourceType.getObjectType());
            GenericConverter converter = FormattingConversionService.this.cachedPrinters.get(key);
            if (converter == null) {
                Printer<?> printer = this.formatterFactory.getPrinter(key.annotation, key.fieldType);
                converter = new PrinterConverter(this.fieldType, printer, (ConversionService)FormattingConversionService.this);
                FormattingConversionService.this.cachedPrinters.put(key, converter);
            }
            return converter.convert(source, sourceType, targetType);
        }

        public String toString() {
            return "@" + this.annotationType.getName() + " " + this.fieldType.getName() + " -> " + String.class.getName() + ": " + this.formatterFactory;
        }
    }

    private class AnnotationParserConverter
    implements ConditionalGenericConverter {
        private final Class<? extends Annotation> annotationType;
        private final AnnotationFormatterFactory formatterFactory;
        private final Class<?> fieldType;

        public AnnotationParserConverter(Class<? extends Annotation> annotationType, AnnotationFormatterFactory<?> formatterFactory, Class<?> fieldType) {
            this.fieldType = fieldType;
            this.annotationType = annotationType;
            this.formatterFactory = formatterFactory;
        }

        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return Collections.singleton(new GenericConverter.ConvertiblePair(String.class, this.fieldType));
        }

        public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
            return targetType.hasAnnotation(this.annotationType);
        }

        @Nullable
        public Object convert(@Nullable Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            Annotation ann = FormattingConversionService.getAnnotation(targetType, this.annotationType);
            ConverterKey key = new ConverterKey(ann, targetType.getObjectType());
            GenericConverter converter = FormattingConversionService.this.cachedParsers.get(key);
            if (converter == null) {
                Parser<?> parser = this.formatterFactory.getParser(key.annotation, key.fieldType);
                converter = new ParserConverter(this.fieldType, parser, (ConversionService)FormattingConversionService.this);
                FormattingConversionService.this.cachedParsers.put(key, converter);
            }
            return converter.convert(source, sourceType, targetType);
        }

        public String toString() {
            return String.class.getName() + " -> @" + this.annotationType.getName() + " " + this.fieldType.getName() + ": " + this.formatterFactory;
        }
    }

    private static final class ConverterKey {
        public final Annotation annotation;
        public final Class<?> fieldType;

        private ConverterKey(Annotation annotation, Class<?> fieldType) {
            this.annotation = annotation;
            this.fieldType = fieldType;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ConverterKey)) {
                return false;
            }
            ConverterKey otherKey = (ConverterKey)other;
            return this.fieldType == otherKey.fieldType && this.annotation.equals(otherKey.annotation);
        }

        public int hashCode() {
            return this.fieldType.hashCode() * 29 + this.annotation.hashCode();
        }
    }
}

