/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.format.support;

import cn.taketoday.core.TypeDescriptor;
import cn.taketoday.core.conversion.GenericConverter;
import cn.taketoday.format.annotation.DurationFormat;
import cn.taketoday.format.annotation.DurationStyle;
import cn.taketoday.format.annotation.DurationUnit;
import cn.taketoday.lang.Nullable;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Set;

final class DurationToStringConverter
implements GenericConverter {
    DurationToStringConverter() {
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Duration.class, String.class));
    }

    @Nullable
    public Object convert(@Nullable Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        return this.convert((Duration)source, this.getDurationStyle(sourceType), this.getDurationUnit(sourceType));
    }

    @Nullable
    private ChronoUnit getDurationUnit(TypeDescriptor sourceType) {
        DurationUnit annotation = (DurationUnit)sourceType.getAnnotation(DurationUnit.class);
        return annotation != null ? annotation.value() : null;
    }

    @Nullable
    private DurationStyle getDurationStyle(TypeDescriptor sourceType) {
        DurationFormat annotation = (DurationFormat)sourceType.getAnnotation(DurationFormat.class);
        return annotation != null ? annotation.value() : null;
    }

    private String convert(Duration source, @Nullable DurationStyle style, @Nullable ChronoUnit unit) {
        style = style != null ? style : DurationStyle.ISO8601;
        return style.print(source, unit);
    }
}

