/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.format.support;

import cn.taketoday.core.TypeDescriptor;
import cn.taketoday.core.conversion.GenericConverter;
import cn.taketoday.format.annotation.DurationStyle;
import cn.taketoday.format.annotation.DurationUnit;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ReflectionUtils;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Set;

final class DurationToNumberConverter
implements GenericConverter {
    DurationToNumberConverter() {
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Duration.class, Number.class));
    }

    @Nullable
    public Object convert(@Nullable Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        return this.convert((Duration)source, this.getDurationUnit(sourceType), targetType.getObjectType());
    }

    @Nullable
    private ChronoUnit getDurationUnit(TypeDescriptor sourceType) {
        DurationUnit annotation = (DurationUnit)sourceType.getAnnotation(DurationUnit.class);
        return annotation != null ? annotation.value() : null;
    }

    private Object convert(Duration source, @Nullable ChronoUnit unit, Class<?> type) {
        try {
            return type.getConstructor(String.class).newInstance(String.valueOf(DurationStyle.Unit.fromChronoUnit(unit).longValue(source)));
        }
        catch (Exception ex) {
            ReflectionUtils.rethrowRuntimeException((Throwable)ex);
            throw new IllegalStateException(ex);
        }
    }
}

