/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.format.support;

import cn.taketoday.core.TypeDescriptor;
import cn.taketoday.core.conversion.ConditionalGenericConverter;
import cn.taketoday.core.conversion.ConversionService;
import cn.taketoday.core.conversion.GenericConverter;
import cn.taketoday.format.annotation.Delimiter;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.CollectionUtils;
import cn.taketoday.util.StringUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Stream;

final class DelimitedStringToCollectionConverter
implements ConditionalGenericConverter {
    private final ConversionService conversionService;

    DelimitedStringToCollectionConverter(ConversionService conversionService) {
        Assert.notNull((Object)conversionService, (String)"ConversionService must not be null");
        this.conversionService = conversionService;
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(String.class, Collection.class));
    }

    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return targetType.getElementDescriptor() == null || this.conversionService.canConvert(sourceType, targetType.getElementDescriptor());
    }

    @Nullable
    public Object convert(@Nullable Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        return this.convert((String)source, sourceType, targetType);
    }

    private Object convert(String source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        Delimiter delimiter = (Delimiter)targetType.getAnnotation(Delimiter.class);
        String[] elements = this.getElements(source, delimiter != null ? delimiter.value() : ",");
        TypeDescriptor elementDescriptor = targetType.getElementDescriptor();
        Collection<Object> target = this.createCollection(targetType, elementDescriptor, elements.length);
        Stream<Object> stream = Arrays.stream(elements).map(String::trim);
        if (elementDescriptor != null) {
            stream = stream.map(element -> this.conversionService.convert(element, sourceType, elementDescriptor));
        }
        stream.forEach(target::add);
        return target;
    }

    private Collection<Object> createCollection(TypeDescriptor targetType, @Nullable TypeDescriptor elementDescriptor, int length) {
        return CollectionUtils.createCollection((Class)targetType.getType(), (Class)(elementDescriptor != null ? elementDescriptor.getType() : null), (int)length);
    }

    private String[] getElements(String source, String delimiter) {
        return StringUtils.delimitedListToStringArray((String)source, (String)("".equals(delimiter) ? null : delimiter));
    }
}

