/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.format.support;

import cn.taketoday.core.TypeDescriptor;
import cn.taketoday.core.conversion.ConditionalGenericConverter;
import cn.taketoday.core.conversion.ConversionService;
import cn.taketoday.core.conversion.GenericConverter;
import cn.taketoday.format.annotation.Delimiter;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.StringUtils;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.Set;

final class DelimitedStringToArrayConverter
implements ConditionalGenericConverter {
    private final ConversionService conversionService;

    DelimitedStringToArrayConverter(ConversionService conversionService) {
        Assert.notNull((Object)conversionService, (String)"ConversionService must not be null");
        this.conversionService = conversionService;
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(String.class, Object[].class));
    }

    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return targetType.getElementDescriptor() == null || this.conversionService.canConvert(sourceType, targetType.getElementDescriptor());
    }

    @Nullable
    public Object convert(@Nullable Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        return this.convert((String)source, sourceType, targetType);
    }

    private Object convert(String source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        Delimiter delimiter = (Delimiter)targetType.getAnnotation(Delimiter.class);
        String[] elements = this.getElements(source, delimiter != null ? delimiter.value() : ",");
        TypeDescriptor elementDescriptor = targetType.getElementDescriptor();
        Object target = Array.newInstance(elementDescriptor.getType(), elements.length);
        for (int i = 0; i < elements.length; ++i) {
            String sourceElement = elements[i];
            Object targetElement = this.conversionService.convert((Object)sourceElement.trim(), sourceType, elementDescriptor);
            Array.set(target, i, targetElement);
        }
        return target;
    }

    private String[] getElements(String source, String delimiter) {
        return StringUtils.delimitedListToStringArray((String)source, (String)("".equals(delimiter) ? null : delimiter));
    }
}

