/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.format.support;

import cn.taketoday.core.StringValueResolver;
import cn.taketoday.core.conversion.ConverterRegistry;
import cn.taketoday.core.conversion.support.DefaultConversionService;
import cn.taketoday.format.FormatterRegistry;
import cn.taketoday.format.datetime.DateFormatterRegistrar;
import cn.taketoday.format.datetime.standard.DateTimeFormatterRegistrar;
import cn.taketoday.format.number.NumberFormatAnnotationFormatterFactory;
import cn.taketoday.format.number.money.CurrencyUnitFormatter;
import cn.taketoday.format.number.money.Jsr354NumberFormatAnnotationFormatterFactory;
import cn.taketoday.format.number.money.MonetaryAmountFormatter;
import cn.taketoday.format.support.FormattingConversionService;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ClassUtils;

public class DefaultFormattingConversionService
extends FormattingConversionService {
    protected static final boolean jsr354Present = ClassUtils.isPresent((String)"javax.money.MonetaryAmount", (ClassLoader)DefaultFormattingConversionService.class.getClassLoader());

    public DefaultFormattingConversionService() {
        this(null, true);
    }

    public DefaultFormattingConversionService(boolean registerDefaultFormatters) {
        this(null, registerDefaultFormatters);
    }

    public DefaultFormattingConversionService(@Nullable StringValueResolver embeddedValueResolver, boolean registerDefaultFormatters) {
        if (embeddedValueResolver != null) {
            this.setEmbeddedValueResolver(embeddedValueResolver);
        }
        DefaultConversionService.addDefaultConverters((ConverterRegistry)this);
        if (registerDefaultFormatters) {
            DefaultFormattingConversionService.addDefaultFormatters(this);
        }
    }

    public static void addDefaultFormatters(FormatterRegistry formatterRegistry) {
        formatterRegistry.addFormatterForFieldAnnotation(new NumberFormatAnnotationFormatterFactory());
        if (jsr354Present) {
            formatterRegistry.addFormatter(new CurrencyUnitFormatter());
            formatterRegistry.addFormatter(new MonetaryAmountFormatter());
            formatterRegistry.addFormatterForFieldAnnotation(new Jsr354NumberFormatAnnotationFormatterFactory());
        }
        new DateTimeFormatterRegistrar().registerFormatters(formatterRegistry);
        new DateFormatterRegistrar().registerFormatters(formatterRegistry);
    }
}

