/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.format.support;

import cn.taketoday.core.TypeDescriptor;
import cn.taketoday.core.conversion.ConditionalGenericConverter;
import cn.taketoday.core.conversion.ConversionService;
import cn.taketoday.core.conversion.GenericConverter;
import cn.taketoday.format.support.ApplicationConversionService;
import cn.taketoday.lang.Nullable;
import java.util.Collections;
import java.util.Set;

class CharSequenceToObjectConverter
implements ConditionalGenericConverter {
    private static final TypeDescriptor STRING = TypeDescriptor.valueOf(String.class);
    private static final TypeDescriptor BYTE_ARRAY = TypeDescriptor.valueOf(byte[].class);
    private static final Set<GenericConverter.ConvertiblePair> TYPES = Collections.singleton(new GenericConverter.ConvertiblePair(CharSequence.class, Object.class));
    private final ThreadLocal<Boolean> disable = new ThreadLocal();
    private final ConversionService conversionService;

    CharSequenceToObjectConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return TYPES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (sourceType.getType() == String.class || this.disable.get() == Boolean.TRUE) {
            return false;
        }
        this.disable.set(Boolean.TRUE);
        try {
            boolean canDirectlyConvertCharSequence = this.conversionService.canConvert(sourceType, targetType);
            if (canDirectlyConvertCharSequence && !this.isStringConversionBetter(sourceType, targetType)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.conversionService.canConvert(STRING, targetType);
            return bl;
        }
        finally {
            this.disable.remove();
        }
    }

    private boolean isStringConversionBetter(TypeDescriptor sourceType, TypeDescriptor targetType) {
        ApplicationConversionService applicationConversionService;
        ConversionService conversionService = this.conversionService;
        if (conversionService instanceof ApplicationConversionService && (applicationConversionService = (ApplicationConversionService)conversionService).isConvertViaObjectSourceType(sourceType, targetType)) {
            return true;
        }
        return (targetType.isArray() || targetType.isCollection()) && !targetType.equals((Object)BYTE_ARRAY);
    }

    @Nullable
    public Object convert(@Nullable Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        return this.conversionService.convert((Object)source.toString(), STRING, targetType);
    }
}

