/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.format.support;

import cn.taketoday.beans.factory.BeanFactory;
import cn.taketoday.core.StringValueResolver;
import cn.taketoday.core.TypeDescriptor;
import cn.taketoday.core.conversion.ConversionService;
import cn.taketoday.core.conversion.Converter;
import cn.taketoday.core.conversion.ConverterFactory;
import cn.taketoday.core.conversion.ConverterRegistry;
import cn.taketoday.core.conversion.GenericConverter;
import cn.taketoday.core.conversion.support.DefaultConversionService;
import cn.taketoday.format.AnnotationFormatterFactory;
import cn.taketoday.format.Formatter;
import cn.taketoday.format.FormatterRegistry;
import cn.taketoday.format.Parser;
import cn.taketoday.format.Printer;
import cn.taketoday.format.support.ArrayToDelimitedStringConverter;
import cn.taketoday.format.support.CharArrayFormatter;
import cn.taketoday.format.support.CharSequenceToObjectConverter;
import cn.taketoday.format.support.CollectionToDelimitedStringConverter;
import cn.taketoday.format.support.DefaultFormattingConversionService;
import cn.taketoday.format.support.DelimitedStringToArrayConverter;
import cn.taketoday.format.support.DelimitedStringToCollectionConverter;
import cn.taketoday.format.support.DurationToNumberConverter;
import cn.taketoday.format.support.DurationToStringConverter;
import cn.taketoday.format.support.FormattingConversionService;
import cn.taketoday.format.support.InetAddressFormatter;
import cn.taketoday.format.support.InputStreamSourceToByteArrayConverter;
import cn.taketoday.format.support.IsoOffsetFormatter;
import cn.taketoday.format.support.LenientBooleanToEnumConverterFactory;
import cn.taketoday.format.support.LenientStringToEnumConverterFactory;
import cn.taketoday.format.support.NumberToDataSizeConverter;
import cn.taketoday.format.support.NumberToDurationConverter;
import cn.taketoday.format.support.NumberToPeriodConverter;
import cn.taketoday.format.support.PeriodToStringConverter;
import cn.taketoday.format.support.StringToDataSizeConverter;
import cn.taketoday.format.support.StringToDurationConverter;
import cn.taketoday.format.support.StringToFileConverter;
import cn.taketoday.format.support.StringToPeriodConverter;
import cn.taketoday.lang.Nullable;
import java.lang.annotation.Annotation;
import java.util.LinkedHashSet;
import java.util.Set;

public class ApplicationConversionService
extends FormattingConversionService {
    @Nullable
    private static volatile ApplicationConversionService sharedInstance;
    private final boolean unmodifiable;

    public ApplicationConversionService() {
        this(null);
    }

    public ApplicationConversionService(@Nullable StringValueResolver embeddedValueResolver) {
        this(embeddedValueResolver, false);
    }

    private ApplicationConversionService(@Nullable StringValueResolver embeddedValueResolver, boolean unmodifiable) {
        if (embeddedValueResolver != null) {
            this.setEmbeddedValueResolver(embeddedValueResolver);
        }
        ApplicationConversionService.configure(this);
        this.unmodifiable = unmodifiable;
    }

    @Override
    public void addPrinter(Printer<?> printer) {
        this.assertModifiable();
        super.addPrinter(printer);
    }

    @Override
    public void addParser(Parser<?> parser) {
        this.assertModifiable();
        super.addParser(parser);
    }

    @Override
    public void addFormatter(Formatter<?> formatter) {
        this.assertModifiable();
        super.addFormatter(formatter);
    }

    @Override
    public void addFormatterForFieldType(Class<?> fieldType, Formatter<?> formatter) {
        this.assertModifiable();
        super.addFormatterForFieldType(fieldType, formatter);
    }

    public void addConverter(Converter<?, ?> converter) {
        this.assertModifiable();
        super.addConverter(converter);
    }

    @Override
    public void addFormatterForFieldType(Class<?> fieldType, Printer<?> printer, Parser<?> parser) {
        this.assertModifiable();
        super.addFormatterForFieldType(fieldType, printer, parser);
    }

    @Override
    public <T extends Annotation> void addFormatterForFieldAnnotation(AnnotationFormatterFactory<T> factory) {
        this.assertModifiable();
        super.addFormatterForFieldAnnotation(factory);
    }

    public <S, T> void addConverter(Class<S> sourceType, Class<T> targetType, Converter<? super S, ? extends T> converter) {
        this.assertModifiable();
        super.addConverter(sourceType, targetType, converter);
    }

    public void addConverter(GenericConverter converter) {
        this.assertModifiable();
        super.addConverter(converter);
    }

    public void addConverterFactory(ConverterFactory<?, ?> factory) {
        this.assertModifiable();
        super.addConverterFactory(factory);
    }

    public void removeConvertible(Class<?> sourceType, Class<?> targetType) {
        this.assertModifiable();
        super.removeConvertible(sourceType, targetType);
    }

    private void assertModifiable() {
        if (this.unmodifiable) {
            throw new UnsupportedOperationException("This ApplicationConversionService cannot be modified");
        }
    }

    public boolean isConvertViaObjectSourceType(TypeDescriptor sourceType, TypeDescriptor targetType) {
        Set pairs;
        GenericConverter converter = this.getConverter(sourceType, targetType);
        Set set = pairs = converter != null ? converter.getConvertibleTypes() : null;
        if (pairs != null) {
            for (GenericConverter.ConvertiblePair pair : pairs) {
                if (!Object.class.equals((Object)pair.getSourceType())) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConversionService getSharedInstance() {
        ApplicationConversionService sharedInstance = ApplicationConversionService.sharedInstance;
        if (sharedInstance != null) return sharedInstance;
        Class<ApplicationConversionService> clazz = ApplicationConversionService.class;
        synchronized (ApplicationConversionService.class) {
            sharedInstance = ApplicationConversionService.sharedInstance;
            if (sharedInstance != null) return sharedInstance;
            ApplicationConversionService.sharedInstance = sharedInstance = new ApplicationConversionService(null, true);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sharedInstance;
        }
    }

    public static void configure(FormatterRegistry registry) {
        DefaultConversionService.addDefaultConverters((ConverterRegistry)registry);
        DefaultFormattingConversionService.addDefaultFormatters(registry);
        ApplicationConversionService.addApplicationFormatters(registry);
        ApplicationConversionService.addApplicationConverters(registry);
    }

    public static void addApplicationConverters(ConverterRegistry registry) {
        ApplicationConversionService.addDelimitedStringConverters(registry);
        registry.addConverter((GenericConverter)new StringToDurationConverter());
        registry.addConverter((GenericConverter)new DurationToStringConverter());
        registry.addConverter((GenericConverter)new NumberToDurationConverter());
        registry.addConverter((GenericConverter)new DurationToNumberConverter());
        registry.addConverter((GenericConverter)new StringToPeriodConverter());
        registry.addConverter((GenericConverter)new PeriodToStringConverter());
        registry.addConverter((GenericConverter)new NumberToPeriodConverter());
        registry.addConverter((GenericConverter)new StringToDataSizeConverter());
        registry.addConverter((GenericConverter)new NumberToDataSizeConverter());
        registry.addConverter((Converter)new StringToFileConverter());
        registry.addConverter((Converter)new InputStreamSourceToByteArrayConverter());
        registry.addConverterFactory((ConverterFactory)new LenientStringToEnumConverterFactory());
        registry.addConverterFactory((ConverterFactory)new LenientBooleanToEnumConverterFactory());
        if (registry instanceof ConversionService) {
            ApplicationConversionService.addApplicationConverters(registry, (ConversionService)registry);
        }
    }

    private static void addApplicationConverters(ConverterRegistry registry, ConversionService conversionService) {
        registry.addConverter((GenericConverter)new CharSequenceToObjectConverter(conversionService));
    }

    public static void addDelimitedStringConverters(ConverterRegistry registry) {
        ConversionService service = (ConversionService)registry;
        registry.addConverter((GenericConverter)new ArrayToDelimitedStringConverter(service));
        registry.addConverter((GenericConverter)new CollectionToDelimitedStringConverter(service));
        registry.addConverter((GenericConverter)new DelimitedStringToArrayConverter(service));
        registry.addConverter((GenericConverter)new DelimitedStringToCollectionConverter(service));
    }

    public static void addApplicationFormatters(FormatterRegistry registry) {
        registry.addFormatter(new CharArrayFormatter());
        registry.addFormatter(new InetAddressFormatter());
        registry.addFormatter(new IsoOffsetFormatter());
    }

    public static void addBeans(FormatterRegistry registry, BeanFactory beanFactory) {
        LinkedHashSet beans = new LinkedHashSet();
        beans.addAll(beanFactory.getBeansOfType(GenericConverter.class).values());
        beans.addAll(beanFactory.getBeansOfType(Converter.class).values());
        beans.addAll(beanFactory.getBeansOfType(Printer.class).values());
        beans.addAll(beanFactory.getBeansOfType(Parser.class).values());
        for (Object bean : beans) {
            if (bean instanceof GenericConverter) {
                registry.addConverter((GenericConverter)bean);
                continue;
            }
            if (bean instanceof Converter) {
                registry.addConverter((Converter)bean);
                continue;
            }
            if (bean instanceof Formatter) {
                registry.addFormatter((Formatter)bean);
                continue;
            }
            if (bean instanceof Printer) {
                registry.addPrinter((Printer)bean);
                continue;
            }
            if (!(bean instanceof Parser)) continue;
            registry.addParser((Parser)bean);
        }
    }
}

