/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.format.number.money;

import cn.taketoday.format.Formatter;
import cn.taketoday.lang.Nullable;
import java.util.Locale;
import javax.money.MonetaryAmount;
import javax.money.format.MonetaryAmountFormat;
import javax.money.format.MonetaryFormats;

public class MonetaryAmountFormatter
implements Formatter<MonetaryAmount> {
    @Nullable
    private String formatName;

    public MonetaryAmountFormatter() {
    }

    public MonetaryAmountFormatter(String formatName) {
        this.formatName = formatName;
    }

    public void setFormatName(String formatName) {
        this.formatName = formatName;
    }

    @Override
    public String print(MonetaryAmount object, Locale locale) {
        return this.getMonetaryAmountFormat(locale).format(object);
    }

    @Override
    public MonetaryAmount parse(String text, Locale locale) {
        return this.getMonetaryAmountFormat(locale).parse((CharSequence)text);
    }

    protected MonetaryAmountFormat getMonetaryAmountFormat(Locale locale) {
        if (this.formatName != null) {
            return MonetaryFormats.getAmountFormat((String)this.formatName, (String[])new String[0]);
        }
        return MonetaryFormats.getAmountFormat((Locale)locale, (String[])new String[0]);
    }
}

