/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.format.number;

import cn.taketoday.context.support.EmbeddedValueResolutionSupport;
import cn.taketoday.format.AnnotationFormatterFactory;
import cn.taketoday.format.Formatter;
import cn.taketoday.format.Parser;
import cn.taketoday.format.Printer;
import cn.taketoday.format.annotation.NumberFormat;
import cn.taketoday.format.number.CurrencyStyleFormatter;
import cn.taketoday.format.number.NumberStyleFormatter;
import cn.taketoday.format.number.PercentStyleFormatter;
import cn.taketoday.util.NumberUtils;
import cn.taketoday.util.StringUtils;
import java.util.Set;

public class NumberFormatAnnotationFormatterFactory
extends EmbeddedValueResolutionSupport
implements AnnotationFormatterFactory<NumberFormat> {
    @Override
    public Set<Class<?>> getFieldTypes() {
        return NumberUtils.STANDARD_NUMBER_TYPES;
    }

    @Override
    public Printer<Number> getPrinter(NumberFormat annotation, Class<?> fieldType) {
        return this.configureFormatterFrom(annotation);
    }

    @Override
    public Parser<Number> getParser(NumberFormat annotation, Class<?> fieldType) {
        return this.configureFormatterFrom(annotation);
    }

    private Formatter<Number> configureFormatterFrom(NumberFormat annotation) {
        String pattern = this.resolveEmbeddedValue(annotation.pattern());
        if (StringUtils.isNotEmpty((CharSequence)pattern)) {
            return new NumberStyleFormatter(pattern);
        }
        NumberFormat.Style style = annotation.style();
        if (style == NumberFormat.Style.CURRENCY) {
            return new CurrencyStyleFormatter();
        }
        if (style == NumberFormat.Style.PERCENT) {
            return new PercentStyleFormatter();
        }
        return new NumberStyleFormatter();
    }
}

