/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.format.datetime.standard;

import cn.taketoday.format.FormatterRegistrar;
import cn.taketoday.format.FormatterRegistry;
import cn.taketoday.format.annotation.DateTimeFormat;
import cn.taketoday.format.datetime.standard.DateTimeConverters;
import cn.taketoday.format.datetime.standard.DateTimeFormatterFactory;
import cn.taketoday.format.datetime.standard.DurationFormatter;
import cn.taketoday.format.datetime.standard.InstantFormatter;
import cn.taketoday.format.datetime.standard.Jsr310DateTimeFormatAnnotationFormatterFactory;
import cn.taketoday.format.datetime.standard.MonthDayFormatter;
import cn.taketoday.format.datetime.standard.MonthFormatter;
import cn.taketoday.format.datetime.standard.PeriodFormatter;
import cn.taketoday.format.datetime.standard.TemporalAccessorParser;
import cn.taketoday.format.datetime.standard.TemporalAccessorPrinter;
import cn.taketoday.format.datetime.standard.YearFormatter;
import cn.taketoday.format.datetime.standard.YearMonthFormatter;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.EnumMap;

public class DateTimeFormatterRegistrar
implements FormatterRegistrar {
    private final EnumMap<Type, DateTimeFormatter> formatters = new EnumMap(Type.class);
    private final EnumMap<Type, DateTimeFormatterFactory> factories = new EnumMap(Type.class);

    public DateTimeFormatterRegistrar() {
        for (Type type : Type.values()) {
            this.factories.put(type, new DateTimeFormatterFactory());
        }
    }

    public void setUseIsoFormat(boolean useIsoFormat) {
        this.factories.get((Object)Type.DATE).setIso(useIsoFormat ? DateTimeFormat.ISO.DATE : DateTimeFormat.ISO.NONE);
        this.factories.get((Object)Type.TIME).setIso(useIsoFormat ? DateTimeFormat.ISO.TIME : DateTimeFormat.ISO.NONE);
        this.factories.get((Object)Type.DATE_TIME).setIso(useIsoFormat ? DateTimeFormat.ISO.DATE_TIME : DateTimeFormat.ISO.NONE);
    }

    public void setDateStyle(FormatStyle dateStyle) {
        this.factories.get((Object)Type.DATE).setDateStyle(dateStyle);
    }

    public void setTimeStyle(FormatStyle timeStyle) {
        this.factories.get((Object)Type.TIME).setTimeStyle(timeStyle);
    }

    public void setDateTimeStyle(FormatStyle dateTimeStyle) {
        this.factories.get((Object)Type.DATE_TIME).setDateTimeStyle(dateTimeStyle);
    }

    public void setDateFormatter(DateTimeFormatter formatter) {
        this.formatters.put(Type.DATE, formatter);
    }

    public void setTimeFormatter(DateTimeFormatter formatter) {
        this.formatters.put(Type.TIME, formatter);
    }

    public void setDateTimeFormatter(DateTimeFormatter formatter) {
        this.formatters.put(Type.DATE_TIME, formatter);
    }

    @Override
    public void registerFormatters(FormatterRegistry registry) {
        DateTimeConverters.registerConverters(registry);
        DateTimeFormatter df = this.getFormatter(Type.DATE);
        DateTimeFormatter tf = this.getFormatter(Type.TIME);
        DateTimeFormatter dtf = this.getFormatter(Type.DATE_TIME);
        registry.addFormatterForFieldType(LocalDate.class, new TemporalAccessorPrinter(df == DateTimeFormatter.ISO_DATE ? DateTimeFormatter.ISO_LOCAL_DATE : df), new TemporalAccessorParser(LocalDate.class, df));
        registry.addFormatterForFieldType(LocalTime.class, new TemporalAccessorPrinter(tf == DateTimeFormatter.ISO_TIME ? DateTimeFormatter.ISO_LOCAL_TIME : tf), new TemporalAccessorParser(LocalTime.class, tf));
        registry.addFormatterForFieldType(LocalDateTime.class, new TemporalAccessorPrinter(dtf == DateTimeFormatter.ISO_DATE_TIME ? DateTimeFormatter.ISO_LOCAL_DATE_TIME : dtf), new TemporalAccessorParser(LocalDateTime.class, dtf));
        registry.addFormatterForFieldType(ZonedDateTime.class, new TemporalAccessorPrinter(dtf), new TemporalAccessorParser(ZonedDateTime.class, dtf));
        registry.addFormatterForFieldType(OffsetDateTime.class, new TemporalAccessorPrinter(dtf), new TemporalAccessorParser(OffsetDateTime.class, dtf));
        registry.addFormatterForFieldType(OffsetTime.class, new TemporalAccessorPrinter(tf), new TemporalAccessorParser(OffsetTime.class, tf));
        registry.addFormatterForFieldType(Instant.class, new InstantFormatter());
        registry.addFormatterForFieldType(Period.class, new PeriodFormatter());
        registry.addFormatterForFieldType(Duration.class, new DurationFormatter());
        registry.addFormatterForFieldType(Year.class, new YearFormatter());
        registry.addFormatterForFieldType(Month.class, new MonthFormatter());
        registry.addFormatterForFieldType(YearMonth.class, new YearMonthFormatter());
        registry.addFormatterForFieldType(MonthDay.class, new MonthDayFormatter());
        registry.addFormatterForFieldAnnotation(new Jsr310DateTimeFormatAnnotationFormatterFactory());
    }

    private DateTimeFormatter getFormatter(Type type) {
        DateTimeFormatter formatter = this.formatters.get((Object)type);
        if (formatter != null) {
            return formatter;
        }
        DateTimeFormatter fallbackFormatter = this.getFallbackFormatter(type);
        return this.factories.get((Object)type).createDateTimeFormatter(fallbackFormatter);
    }

    private DateTimeFormatter getFallbackFormatter(Type type) {
        return switch (type) {
            case Type.DATE -> DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT);
            case Type.TIME -> DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT);
            default -> DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT);
        };
    }

    private static enum Type {
        DATE,
        TIME,
        DATE_TIME;

    }
}

