/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.format.datetime.standard;

import cn.taketoday.core.NamedThreadLocal;
import cn.taketoday.format.datetime.standard.DateTimeContext;
import cn.taketoday.lang.Nullable;
import java.time.format.DateTimeFormatter;
import java.util.Locale;

public final class DateTimeContextHolder {
    private static final ThreadLocal<DateTimeContext> dateTimeContextHolder = new NamedThreadLocal("DateTimeContext");

    private DateTimeContextHolder() {
    }

    public static void resetDateTimeContext() {
        dateTimeContextHolder.remove();
    }

    public static void setDateTimeContext(@Nullable DateTimeContext dateTimeContext) {
        if (dateTimeContext == null) {
            DateTimeContextHolder.resetDateTimeContext();
        } else {
            dateTimeContextHolder.set(dateTimeContext);
        }
    }

    @Nullable
    public static DateTimeContext getDateTimeContext() {
        return dateTimeContextHolder.get();
    }

    public static DateTimeFormatter getFormatter(DateTimeFormatter formatter, @Nullable Locale locale) {
        DateTimeContext context;
        if (locale != null) {
            formatter = formatter.withLocale(locale);
        }
        if ((context = DateTimeContextHolder.getDateTimeContext()) != null) {
            formatter = context.getFormatter(formatter);
        }
        return formatter;
    }
}

