/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.format.datetime;

import cn.taketoday.context.support.EmbeddedValueResolutionSupport;
import cn.taketoday.format.AnnotationFormatterFactory;
import cn.taketoday.format.Formatter;
import cn.taketoday.format.Parser;
import cn.taketoday.format.Printer;
import cn.taketoday.format.annotation.DateTimeFormat;
import cn.taketoday.format.datetime.DateFormatter;
import cn.taketoday.util.StringUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;

public class DateTimeFormatAnnotationFormatterFactory
extends EmbeddedValueResolutionSupport
implements AnnotationFormatterFactory<DateTimeFormat> {
    @Override
    public Set<Class<?>> getFieldTypes() {
        return Set.of(Date.class, Calendar.class, Long.class);
    }

    @Override
    public Printer<?> getPrinter(DateTimeFormat annotation, Class<?> fieldType) {
        return this.getFormatter(annotation, fieldType);
    }

    @Override
    public Parser<?> getParser(DateTimeFormat annotation, Class<?> fieldType) {
        return this.getFormatter(annotation, fieldType);
    }

    protected Formatter<Date> getFormatter(DateTimeFormat annotation, Class<?> fieldType) {
        String pattern;
        DateFormatter formatter = new DateFormatter();
        formatter.setSource(annotation);
        formatter.setIso(annotation.iso());
        String style = this.resolveEmbeddedValue(annotation.style());
        if (StringUtils.isNotEmpty((CharSequence)style)) {
            formatter.setStylePattern(style);
        }
        if (StringUtils.isNotEmpty((CharSequence)(pattern = this.resolveEmbeddedValue(annotation.pattern())))) {
            formatter.setPattern(pattern);
        }
        ArrayList<String> resolvedFallbackPatterns = new ArrayList<String>();
        for (String fallbackPattern : annotation.fallbackPatterns()) {
            String resolvedFallbackPattern = this.resolveEmbeddedValue(fallbackPattern);
            if (!StringUtils.isNotEmpty((CharSequence)resolvedFallbackPattern)) continue;
            resolvedFallbackPatterns.add(resolvedFallbackPattern);
        }
        if (!resolvedFallbackPatterns.isEmpty()) {
            formatter.setFallbackPatterns(StringUtils.toStringArray(resolvedFallbackPatterns));
        }
        return formatter;
    }
}

