/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.ejb.config;

import cn.taketoday.beans.factory.config.RuntimeBeanReference;
import cn.taketoday.beans.factory.support.BeanDefinitionBuilder;
import cn.taketoday.beans.factory.xml.AbstractSimpleBeanDefinitionParser;
import cn.taketoday.util.StringUtils;
import cn.taketoday.util.xml.DomUtils;
import org.w3c.dom.Element;

abstract class AbstractJndiLocatingBeanDefinitionParser
extends AbstractSimpleBeanDefinitionParser {
    public static final String ENVIRONMENT = "environment";
    public static final String ENVIRONMENT_REF = "environment-ref";
    public static final String JNDI_ENVIRONMENT = "jndiEnvironment";

    AbstractJndiLocatingBeanDefinitionParser() {
    }

    protected boolean isEligibleAttribute(String attributeName) {
        return super.isEligibleAttribute(attributeName) && !ENVIRONMENT_REF.equals(attributeName) && !"lazy-init".equals(attributeName);
    }

    protected void postProcess(BeanDefinitionBuilder definitionBuilder, Element element) {
        String envValue = DomUtils.getChildElementValueByTagName((Element)element, (String)ENVIRONMENT);
        if (envValue != null) {
            definitionBuilder.addPropertyValue(JNDI_ENVIRONMENT, (Object)envValue);
        } else {
            String envRef = element.getAttribute(ENVIRONMENT_REF);
            if (StringUtils.isNotEmpty((CharSequence)envRef)) {
                definitionBuilder.addPropertyValue(JNDI_ENVIRONMENT, (Object)new RuntimeBeanReference(envRef));
            }
        }
        String lazyInit = element.getAttribute("lazy-init");
        if (StringUtils.hasText((String)lazyInit) && !"default".equals(lazyInit)) {
            definitionBuilder.setLazyInit("true".equals(lazyInit));
        }
    }
}

