/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.weaving;

import cn.taketoday.beans.BeansException;
import cn.taketoday.beans.factory.BeanFactory;
import cn.taketoday.beans.factory.BeanFactoryAware;
import cn.taketoday.beans.factory.InitializationBeanPostProcessor;
import cn.taketoday.context.weaving.LoadTimeWeaverAware;
import cn.taketoday.instrument.LoadTimeWeaver;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;

public class LoadTimeWeaverAwareProcessor
implements InitializationBeanPostProcessor,
BeanFactoryAware {
    @Nullable
    private LoadTimeWeaver loadTimeWeaver;
    @Nullable
    private BeanFactory beanFactory;

    public LoadTimeWeaverAwareProcessor() {
    }

    public LoadTimeWeaverAwareProcessor(@Nullable LoadTimeWeaver loadTimeWeaver) {
        this.loadTimeWeaver = loadTimeWeaver;
    }

    public LoadTimeWeaverAwareProcessor(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof LoadTimeWeaverAware) {
            LoadTimeWeaver ltw = this.loadTimeWeaver;
            if (ltw == null) {
                Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory required if no LoadTimeWeaver explicitly specified");
                ltw = (LoadTimeWeaver)this.beanFactory.getBean("loadTimeWeaver", LoadTimeWeaver.class);
            }
            ((LoadTimeWeaverAware)bean).setLoadTimeWeaver(ltw);
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String name) {
        return bean;
    }
}

