/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.weaving;

import cn.taketoday.beans.factory.BeanClassLoaderAware;
import cn.taketoday.beans.factory.DisposableBean;
import cn.taketoday.instrument.InstrumentationLoadTimeWeaver;
import cn.taketoday.instrument.LoadTimeWeaver;
import cn.taketoday.instrument.ReflectiveLoadTimeWeaver;
import cn.taketoday.instrument.TomcatLoadTimeWeaver;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import java.lang.instrument.ClassFileTransformer;

public class DefaultContextLoadTimeWeaver
implements LoadTimeWeaver,
BeanClassLoaderAware,
DisposableBean {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Nullable
    private LoadTimeWeaver loadTimeWeaver;

    public DefaultContextLoadTimeWeaver() {
    }

    public DefaultContextLoadTimeWeaver(ClassLoader beanClassLoader) {
        this.setBeanClassLoader(beanClassLoader);
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        LoadTimeWeaver serverSpecificLoadTimeWeaver = this.createServerSpecificLoadTimeWeaver(classLoader);
        if (serverSpecificLoadTimeWeaver != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Determined server-specific load-time weaver: {}", (Object)serverSpecificLoadTimeWeaver.getClass().getName());
            }
            this.loadTimeWeaver = serverSpecificLoadTimeWeaver;
        } else if (InstrumentationLoadTimeWeaver.isInstrumentationAvailable()) {
            this.logger.debug("Found Framework's JVM agent for instrumentation");
            this.loadTimeWeaver = new InstrumentationLoadTimeWeaver(classLoader);
        } else {
            try {
                this.loadTimeWeaver = new ReflectiveLoadTimeWeaver(classLoader);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Using reflective load-time weaver for class loader: " + this.loadTimeWeaver.getInstrumentableClassLoader().getClass().getName());
                }
            }
            catch (IllegalStateException ex) {
                throw new IllegalStateException(ex.getMessage() + " Specify a custom LoadTimeWeaver or start your Java virtual machine with Framework's agent: -javaagent:instrument-{version}.jar");
            }
        }
    }

    @Nullable
    protected LoadTimeWeaver createServerSpecificLoadTimeWeaver(ClassLoader classLoader) {
        block3: {
            String name = classLoader.getClass().getName();
            try {
                if (name.startsWith("org.apache.catalina")) {
                    return new TomcatLoadTimeWeaver(classLoader);
                }
            }
            catch (Exception ex) {
                if (!this.logger.isInfoEnabled()) break block3;
                this.logger.info("Could not obtain server-specific LoadTimeWeaver: {}", (Object)ex.getMessage());
            }
        }
        return null;
    }

    public void destroy() {
        if (this.loadTimeWeaver instanceof InstrumentationLoadTimeWeaver) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Removing all registered transformers for class loader: {}", (Object)this.loadTimeWeaver.getInstrumentableClassLoader().getClass().getName());
            }
            ((InstrumentationLoadTimeWeaver)this.loadTimeWeaver).removeTransformers();
        }
    }

    @Override
    public void addTransformer(ClassFileTransformer transformer) {
        Assert.state((this.loadTimeWeaver != null ? 1 : 0) != 0, (String)"Not initialized");
        this.loadTimeWeaver.addTransformer(transformer);
    }

    @Override
    public ClassLoader getInstrumentableClassLoader() {
        Assert.state((this.loadTimeWeaver != null ? 1 : 0) != 0, (String)"Not initialized");
        return this.loadTimeWeaver.getInstrumentableClassLoader();
    }

    @Override
    public ClassLoader getThrowawayClassLoader() {
        Assert.state((this.loadTimeWeaver != null ? 1 : 0) != 0, (String)"Not initialized");
        return this.loadTimeWeaver.getThrowawayClassLoader();
    }
}

