/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.weaving;

import cn.taketoday.beans.BeansException;
import cn.taketoday.beans.factory.BeanClassLoaderAware;
import cn.taketoday.beans.factory.config.BeanFactoryPostProcessor;
import cn.taketoday.beans.factory.config.ConfigurableBeanFactory;
import cn.taketoday.context.weaving.LoadTimeWeaverAware;
import cn.taketoday.core.Ordered;
import cn.taketoday.instrument.InstrumentationLoadTimeWeaver;
import cn.taketoday.instrument.LoadTimeWeaver;
import cn.taketoday.lang.Nullable;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import org.aspectj.weaver.loadtime.ClassPreProcessorAgentAdapter;

public class AspectJWeavingEnabler
implements BeanFactoryPostProcessor,
BeanClassLoaderAware,
LoadTimeWeaverAware,
Ordered {
    public static final String ASPECTJ_AOP_XML_RESOURCE = "META-INF/aop.xml";
    @Nullable
    private ClassLoader beanClassLoader;
    @Nullable
    private LoadTimeWeaver loadTimeWeaver;

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    @Override
    public void setLoadTimeWeaver(LoadTimeWeaver loadTimeWeaver) {
        this.loadTimeWeaver = loadTimeWeaver;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public void postProcessBeanFactory(ConfigurableBeanFactory beanFactory) throws BeansException {
        AspectJWeavingEnabler.enableAspectJWeaving(this.loadTimeWeaver, this.beanClassLoader);
    }

    public static void enableAspectJWeaving(@Nullable LoadTimeWeaver weaverToUse, @Nullable ClassLoader beanClassLoader) {
        if (weaverToUse == null) {
            if (InstrumentationLoadTimeWeaver.isInstrumentationAvailable()) {
                weaverToUse = new InstrumentationLoadTimeWeaver(beanClassLoader);
            } else {
                throw new IllegalStateException("No LoadTimeWeaver available");
            }
        }
        weaverToUse.addTransformer(new AspectJClassBypassingClassFileTransformer((ClassFileTransformer)new ClassPreProcessorAgentAdapter()));
    }

    private record AspectJClassBypassingClassFileTransformer(ClassFileTransformer delegate) implements ClassFileTransformer
    {
        @Override
        public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
            if (className.startsWith("org.aspectj") || className.startsWith("org/aspectj")) {
                return classfileBuffer;
            }
            return this.delegate.transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
        }
    }
}

