/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.support;

import cn.taketoday.beans.factory.config.BeanDefinitionCustomizer;
import cn.taketoday.beans.factory.support.BeanDefinitionRegistry;
import cn.taketoday.beans.factory.support.BeanNameGenerator;
import cn.taketoday.beans.factory.support.StandardBeanFactory;
import cn.taketoday.context.AnnotationConfigRegistry;
import cn.taketoday.context.ApplicationContext;
import cn.taketoday.context.ConfigurableApplicationContext;
import cn.taketoday.context.annotation.AnnotatedBeanDefinitionReader;
import cn.taketoday.context.annotation.ClassPathBeanDefinitionScanner;
import cn.taketoday.context.annotation.ScopeMetadataResolver;
import cn.taketoday.context.support.GenericApplicationContext;
import cn.taketoday.core.env.ConfigurableEnvironment;
import cn.taketoday.core.env.Environment;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import java.util.function.Supplier;

public class StandardApplicationContext
extends GenericApplicationContext
implements ConfigurableApplicationContext,
BeanDefinitionRegistry,
AnnotationConfigRegistry {
    private final AnnotatedBeanDefinitionReader reader = new AnnotatedBeanDefinitionReader(this);
    private final ClassPathBeanDefinitionScanner scanner = new ClassPathBeanDefinitionScanner(this);

    public StandardApplicationContext() {
    }

    public StandardApplicationContext(StandardBeanFactory beanFactory) {
        super(beanFactory);
    }

    public StandardApplicationContext(@Nullable ApplicationContext parent) {
        this.setParent(parent);
    }

    public StandardApplicationContext(StandardBeanFactory beanFactory, ApplicationContext parent) {
        this(beanFactory);
        this.setParent(parent);
    }

    public StandardApplicationContext(Class<?> ... components) {
        this.register(components);
        this.refresh();
    }

    public StandardApplicationContext(String ... basePackages) {
        this.scan(basePackages);
        this.refresh();
    }

    @Override
    public void register(Class<?> ... components) {
        Assert.notEmpty((Object[])components, (String)"At least one component class must be specified");
        this.reader.register(components);
    }

    @Override
    public void scan(String ... basePackages) {
        Assert.notEmpty((Object[])basePackages, (String)"At least one base package must be specified");
        this.scanner.scan(basePackages);
    }

    public void setBeanNameGenerator(BeanNameGenerator beanNameGenerator) {
        Assert.notNull((Object)beanNameGenerator, (String)"BeanNameGenerator is required");
        this.reader.setBeanNameGenerator(beanNameGenerator);
        this.scanner.setBeanNameGenerator(beanNameGenerator);
        this.obtainBootstrapContext().setBeanNameGenerator(beanNameGenerator);
        this.getBeanFactory().registerSingleton("cn.taketoday.context.annotation.internalConfigurationBeanNameGenerator", (Object)beanNameGenerator);
    }

    public void setScopeMetadataResolver(ScopeMetadataResolver scopeMetadataResolver) {
        this.reader.setScopeMetadataResolver(scopeMetadataResolver);
        this.scanner.setScopeMetadataResolver(scopeMetadataResolver);
        this.obtainBootstrapContext().setScopeMetadataResolver(scopeMetadataResolver);
    }

    @Override
    public void setEnvironment(ConfigurableEnvironment environment) {
        super.setEnvironment(environment);
        this.reader.setEnvironment((Environment)environment);
        this.scanner.setEnvironment((Environment)environment);
    }

    @Override
    public <T> void registerBean(@Nullable String beanName, Class<T> beanClass, @Nullable Supplier<T> supplier, BeanDefinitionCustomizer ... customizers) {
        this.reader.registerBean(beanClass, beanName, supplier, customizers);
    }
}

