/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.support;

import cn.taketoday.beans.factory.config.Scope;
import cn.taketoday.core.NamedThreadLocal;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class SimpleThreadScope
implements Scope {
    private static final Logger logger = LoggerFactory.getLogger(SimpleThreadScope.class);
    private final ThreadLocal<Map<String, Object>> threadScope = NamedThreadLocal.withInitial((String)"SimpleThreadScope", HashMap::new);

    public Object remove(String name) {
        Map<String, Object> scope = this.threadScope.get();
        return scope.remove(name);
    }

    public void registerDestructionCallback(String name, Runnable callback) {
        logger.warn("SimpleThreadScope does not support destruction callbacks. Consider using RequestScope in a web environment.");
    }

    public Object get(String beanName, Supplier<?> objectFactory) {
        Map<String, Object> scope = this.threadScope.get();
        Object scopedObject = scope.get(beanName);
        if (scopedObject == null) {
            scopedObject = objectFactory.get();
            scope.put(beanName, scopedObject);
        }
        return scopedObject;
    }

    @Nullable
    public Object resolveContextualObject(String key) {
        return null;
    }

    public String getConversationId() {
        return Thread.currentThread().getName();
    }
}

