/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.support;

import cn.taketoday.beans.BeansException;
import cn.taketoday.beans.factory.BeanInitializationException;
import cn.taketoday.beans.factory.config.ConfigurableBeanFactory;
import cn.taketoday.beans.factory.config.PlaceholderConfigurerSupport;
import cn.taketoday.context.EnvironmentAware;
import cn.taketoday.core.StringValueResolver;
import cn.taketoday.core.env.ConfigurableEnvironment;
import cn.taketoday.core.env.ConfigurablePropertyResolver;
import cn.taketoday.core.env.Environment;
import cn.taketoday.core.env.PropertiesPropertySource;
import cn.taketoday.core.env.PropertyResolver;
import cn.taketoday.core.env.PropertySource;
import cn.taketoday.core.env.PropertySources;
import cn.taketoday.core.env.PropertySourcesPropertyResolver;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import java.io.IOException;
import java.util.Properties;

public class PropertySourcesPlaceholderConfigurer
extends PlaceholderConfigurerSupport
implements EnvironmentAware {
    public static final String LOCAL_PROPERTIES_PROPERTY_SOURCE_NAME = "localProperties";
    public static final String ENVIRONMENT_PROPERTIES_PROPERTY_SOURCE_NAME = "environmentProperties";
    @Nullable
    private PropertySources propertySources;
    @Nullable
    private PropertySources appliedPropertySources;
    @Nullable
    private Environment environment;

    public void setPropertySources(PropertySources propertySources) {
        this.propertySources = new PropertySources(propertySources);
    }

    @Override
    public void setEnvironment(@Nullable Environment environment) {
        this.environment = environment;
    }

    public void postProcessBeanFactory(ConfigurableBeanFactory beanFactory) throws BeansException {
        if (this.propertySources == null) {
            this.propertySources = new PropertySources();
            if (this.environment != null) {
                Environment environment;
                Environment propertyResolver = this.environment;
                if (this.ignoreUnresolvablePlaceholders && (environment = this.environment) instanceof ConfigurableEnvironment) {
                    ConfigurableEnvironment configurableEnvironment = (ConfigurableEnvironment)environment;
                    PropertySourcesPropertyResolver resolver = new PropertySourcesPropertyResolver(configurableEnvironment.getPropertySources());
                    resolver.setIgnoreUnresolvableNestedPlaceholders(true);
                    propertyResolver = resolver;
                }
                Environment propertyResolverToUse = propertyResolver;
                this.propertySources.addLast((PropertySource)new PropertySource<Environment>(ENVIRONMENT_PROPERTIES_PROPERTY_SOURCE_NAME, this.environment, (PropertyResolver)propertyResolverToUse){
                    final /* synthetic */ PropertyResolver val$propertyResolverToUse;
                    {
                        this.val$propertyResolverToUse = propertyResolver;
                        super(name, (Object)source);
                    }

                    @Nullable
                    public String getProperty(String key) {
                        return this.val$propertyResolverToUse.getProperty(key);
                    }
                });
            }
            try {
                PropertiesPropertySource localPropertySource = new PropertiesPropertySource(LOCAL_PROPERTIES_PROPERTY_SOURCE_NAME, this.mergeProperties());
                if (this.localOverride) {
                    this.propertySources.addFirst((PropertySource)localPropertySource);
                } else {
                    this.propertySources.addLast((PropertySource)localPropertySource);
                }
            }
            catch (IOException ex) {
                throw new BeanInitializationException("Could not load properties", (Throwable)ex);
            }
        }
        this.processProperties(beanFactory, (ConfigurablePropertyResolver)new PropertySourcesPropertyResolver(this.propertySources));
        this.appliedPropertySources = this.propertySources;
    }

    protected void processProperties(ConfigurableBeanFactory beanFactoryToProcess, ConfigurablePropertyResolver propertyResolver) throws BeansException {
        propertyResolver.setValueSeparator(this.valueSeparator);
        propertyResolver.setPlaceholderPrefix(this.placeholderPrefix);
        propertyResolver.setPlaceholderSuffix(this.placeholderSuffix);
        StringValueResolver valueResolver = strVal -> {
            String resolved;
            String string = resolved = this.ignoreUnresolvablePlaceholders ? propertyResolver.resolvePlaceholders(strVal) : propertyResolver.resolveRequiredPlaceholders(strVal);
            if (this.trimValues) {
                resolved = resolved.trim();
            }
            return resolved.equals(this.nullValue) ? null : resolved;
        };
        this.doProcessProperties(beanFactoryToProcess, valueResolver);
    }

    protected void processProperties(ConfigurableBeanFactory beanFactory, Properties props) {
        throw new UnsupportedOperationException("Call processProperties(ConfigurableBeanFactory, ConfigurablePropertyResolver) instead");
    }

    public PropertySources getAppliedPropertySources() throws IllegalStateException {
        Assert.state((this.appliedPropertySources != null ? 1 : 0) != 0, (String)"PropertySources have not yet been applied");
        return this.appliedPropertySources;
    }
}

