/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.support;

import cn.taketoday.beans.factory.InitializationBeanPostProcessor;
import cn.taketoday.beans.factory.config.BeanDefinition;
import cn.taketoday.beans.factory.config.BeanFactoryPostProcessor;
import cn.taketoday.beans.factory.config.BeanPostProcessor;
import cn.taketoday.beans.factory.config.ConfigurableBeanFactory;
import cn.taketoday.beans.factory.support.AbstractBeanFactory;
import cn.taketoday.beans.factory.support.BeanDefinitionRegistry;
import cn.taketoday.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import cn.taketoday.beans.factory.support.MergedBeanDefinitionPostProcessor;
import cn.taketoday.beans.factory.support.StandardBeanFactory;
import cn.taketoday.context.support.AbstractApplicationContext;
import cn.taketoday.context.support.ApplicationListenerDetector;
import cn.taketoday.core.OrderComparator;
import cn.taketoday.core.Ordered;
import cn.taketoday.core.PriorityOrdered;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

final class PostProcessorRegistrationDelegate {
    PostProcessorRegistrationDelegate() {
    }

    public static void invokeBeanFactoryPostProcessors(ConfigurableBeanFactory beanFactory, List<BeanFactoryPostProcessor> beanFactoryPostProcessors) {
        HashSet<String> processedBeans = new HashSet<String>();
        if (beanFactory instanceof BeanDefinitionRegistry) {
            Object ppName;
            Object registryProcessor;
            BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
            ArrayList<BeanFactoryPostProcessor> regularPostProcessors = new ArrayList<BeanFactoryPostProcessor>();
            ArrayList<Object> registryProcessors = new ArrayList<Object>();
            for (BeanFactoryPostProcessor postProcessor : beanFactoryPostProcessors) {
                if (postProcessor instanceof BeanDefinitionRegistryPostProcessor) {
                    registryProcessor = (BeanDefinitionRegistryPostProcessor)postProcessor;
                    registryProcessor.postProcessBeanDefinitionRegistry(registry);
                    registryProcessors.add(registryProcessor);
                    continue;
                }
                regularPostProcessors.add(postProcessor);
            }
            ArrayList<BeanDefinitionRegistryPostProcessor> currentRegistryProcessors = new ArrayList<BeanDefinitionRegistryPostProcessor>();
            Object postProcessorNames = beanFactory.getBeanNamesForType(BeanDefinitionRegistryPostProcessor.class, true, false);
            registryProcessor = postProcessorNames.iterator();
            while (registryProcessor.hasNext()) {
                ppName = (String)registryProcessor.next();
                if (!beanFactory.isTypeMatch((String)ppName, PriorityOrdered.class)) continue;
                currentRegistryProcessors.add((BeanDefinitionRegistryPostProcessor)beanFactory.getBean((String)ppName, BeanDefinitionRegistryPostProcessor.class));
                processedBeans.add((String)ppName);
            }
            PostProcessorRegistrationDelegate.sortPostProcessors(currentRegistryProcessors, beanFactory);
            registryProcessors.addAll(currentRegistryProcessors);
            PostProcessorRegistrationDelegate.invokeBeanDefinitionRegistryPostProcessors(currentRegistryProcessors, registry);
            currentRegistryProcessors.clear();
            postProcessorNames = beanFactory.getBeanNamesForType(BeanDefinitionRegistryPostProcessor.class, true, false);
            registryProcessor = postProcessorNames.iterator();
            while (registryProcessor.hasNext()) {
                ppName = (String)registryProcessor.next();
                if (processedBeans.contains(ppName) || !beanFactory.isTypeMatch((String)ppName, Ordered.class)) continue;
                currentRegistryProcessors.add((BeanDefinitionRegistryPostProcessor)beanFactory.getBean((String)ppName, BeanDefinitionRegistryPostProcessor.class));
                processedBeans.add((String)ppName);
            }
            PostProcessorRegistrationDelegate.sortPostProcessors(currentRegistryProcessors, beanFactory);
            registryProcessors.addAll(currentRegistryProcessors);
            PostProcessorRegistrationDelegate.invokeBeanDefinitionRegistryPostProcessors(currentRegistryProcessors, registry);
            currentRegistryProcessors.clear();
            boolean reiterate = true;
            while (reiterate) {
                reiterate = false;
                postProcessorNames = beanFactory.getBeanNamesForType(BeanDefinitionRegistryPostProcessor.class, true, false);
                ppName = postProcessorNames.iterator();
                while (ppName.hasNext()) {
                    String ppName2 = (String)ppName.next();
                    if (processedBeans.contains(ppName2)) continue;
                    currentRegistryProcessors.add((BeanDefinitionRegistryPostProcessor)beanFactory.getBean(ppName2, BeanDefinitionRegistryPostProcessor.class));
                    processedBeans.add(ppName2);
                    reiterate = true;
                }
                PostProcessorRegistrationDelegate.sortPostProcessors(currentRegistryProcessors, beanFactory);
                registryProcessors.addAll(currentRegistryProcessors);
                PostProcessorRegistrationDelegate.invokeBeanDefinitionRegistryPostProcessors(currentRegistryProcessors, registry);
                currentRegistryProcessors.clear();
            }
            PostProcessorRegistrationDelegate.invokeBeanFactoryPostProcessors(registryProcessors, beanFactory);
            PostProcessorRegistrationDelegate.invokeBeanFactoryPostProcessors(regularPostProcessors, beanFactory);
        } else {
            PostProcessorRegistrationDelegate.invokeBeanFactoryPostProcessors(beanFactoryPostProcessors, beanFactory);
        }
        Set postProcessorNames = beanFactory.getBeanNamesForType(BeanFactoryPostProcessor.class, true, false);
        ArrayList<String> orderedPostProcessorNames = new ArrayList<String>();
        ArrayList<String> nonOrderedPostProcessorNames = new ArrayList<String>();
        ArrayList<BeanFactoryPostProcessor> priorityOrderedPostProcessors = new ArrayList<BeanFactoryPostProcessor>();
        for (String ppName : postProcessorNames) {
            if (processedBeans.contains(ppName)) continue;
            if (beanFactory.isTypeMatch(ppName, PriorityOrdered.class)) {
                priorityOrderedPostProcessors.add((BeanFactoryPostProcessor)beanFactory.getBean(ppName, BeanFactoryPostProcessor.class));
                continue;
            }
            if (beanFactory.isTypeMatch(ppName, Ordered.class)) {
                orderedPostProcessorNames.add(ppName);
                continue;
            }
            nonOrderedPostProcessorNames.add(ppName);
        }
        PostProcessorRegistrationDelegate.sortPostProcessors(priorityOrderedPostProcessors, beanFactory);
        PostProcessorRegistrationDelegate.invokeBeanFactoryPostProcessors(priorityOrderedPostProcessors, beanFactory);
        ArrayList<BeanFactoryPostProcessor> orderedPostProcessors = new ArrayList<BeanFactoryPostProcessor>(orderedPostProcessorNames.size());
        for (String postProcessorName : orderedPostProcessorNames) {
            orderedPostProcessors.add((BeanFactoryPostProcessor)beanFactory.getBean(postProcessorName, BeanFactoryPostProcessor.class));
        }
        PostProcessorRegistrationDelegate.sortPostProcessors(orderedPostProcessors, beanFactory);
        PostProcessorRegistrationDelegate.invokeBeanFactoryPostProcessors(orderedPostProcessors, beanFactory);
        ArrayList<BeanFactoryPostProcessor> nonOrderedPostProcessors = new ArrayList<BeanFactoryPostProcessor>(nonOrderedPostProcessorNames.size());
        for (String postProcessorName : nonOrderedPostProcessorNames) {
            nonOrderedPostProcessors.add((BeanFactoryPostProcessor)beanFactory.getBean(postProcessorName, BeanFactoryPostProcessor.class));
        }
        PostProcessorRegistrationDelegate.invokeBeanFactoryPostProcessors(nonOrderedPostProcessors, beanFactory);
        beanFactory.clearMetadataCache();
    }

    public static void registerBeanPostProcessors(ConfigurableBeanFactory beanFactory, AbstractApplicationContext applicationContext) {
        Set postProcessorNames = beanFactory.getBeanNamesForType(BeanPostProcessor.class, true, false);
        int beanProcessorTargetCount = beanFactory.getBeanPostProcessorCount() + 1 + postProcessorNames.size();
        beanFactory.addBeanPostProcessor((BeanPostProcessor)new BeanPostProcessorChecker(beanFactory, beanProcessorTargetCount));
        ArrayList<Object> orderedPostProcessorNames = new ArrayList<Object>();
        ArrayList<Object> nonOrderedPostProcessorNames = new ArrayList<Object>();
        ArrayList<BeanPostProcessor> internalPostProcessors = new ArrayList<BeanPostProcessor>();
        ArrayList<BeanPostProcessor> priorityOrderedPostProcessors = new ArrayList<BeanPostProcessor>();
        for (Object ppName : postProcessorNames) {
            if (beanFactory.isTypeMatch((String)ppName, PriorityOrdered.class)) {
                BeanPostProcessor beanPostProcessor = (BeanPostProcessor)beanFactory.getBean((String)ppName, BeanPostProcessor.class);
                priorityOrderedPostProcessors.add(beanPostProcessor);
                if (!(beanPostProcessor instanceof MergedBeanDefinitionPostProcessor)) continue;
                internalPostProcessors.add(beanPostProcessor);
                continue;
            }
            if (beanFactory.isTypeMatch((String)ppName, Ordered.class)) {
                orderedPostProcessorNames.add(ppName);
                continue;
            }
            nonOrderedPostProcessorNames.add(ppName);
        }
        PostProcessorRegistrationDelegate.sortPostProcessors(priorityOrderedPostProcessors, beanFactory);
        PostProcessorRegistrationDelegate.registerBeanPostProcessors(beanFactory, priorityOrderedPostProcessors);
        ArrayList<BeanPostProcessor> orderedPostProcessors = new ArrayList<BeanPostProcessor>(orderedPostProcessorNames.size());
        for (String string : orderedPostProcessorNames) {
            BeanPostProcessor beanPostProcessor = (BeanPostProcessor)beanFactory.getBean(string, BeanPostProcessor.class);
            orderedPostProcessors.add(beanPostProcessor);
            if (!(beanPostProcessor instanceof MergedBeanDefinitionPostProcessor)) continue;
            internalPostProcessors.add(beanPostProcessor);
        }
        PostProcessorRegistrationDelegate.sortPostProcessors(orderedPostProcessors, beanFactory);
        PostProcessorRegistrationDelegate.registerBeanPostProcessors(beanFactory, orderedPostProcessors);
        ArrayList<BeanPostProcessor> nonOrderedPostProcessors = new ArrayList<BeanPostProcessor>(nonOrderedPostProcessorNames.size());
        for (String string : nonOrderedPostProcessorNames) {
            BeanPostProcessor pp = (BeanPostProcessor)beanFactory.getBean(string, BeanPostProcessor.class);
            nonOrderedPostProcessors.add(pp);
            if (!(pp instanceof MergedBeanDefinitionPostProcessor)) continue;
            internalPostProcessors.add(pp);
        }
        PostProcessorRegistrationDelegate.registerBeanPostProcessors(beanFactory, nonOrderedPostProcessors);
        PostProcessorRegistrationDelegate.sortPostProcessors(internalPostProcessors, beanFactory);
        PostProcessorRegistrationDelegate.registerBeanPostProcessors(beanFactory, internalPostProcessors);
        beanFactory.addBeanPostProcessor((BeanPostProcessor)new ApplicationListenerDetector(applicationContext));
    }

    private static void sortPostProcessors(List<?> postProcessors, ConfigurableBeanFactory beanFactory) {
        if (postProcessors.size() <= 1) {
            return;
        }
        Object comparatorToUse = null;
        if (beanFactory instanceof StandardBeanFactory) {
            StandardBeanFactory std = (StandardBeanFactory)beanFactory;
            comparatorToUse = std.getDependencyComparator();
        }
        if (comparatorToUse == null) {
            comparatorToUse = OrderComparator.INSTANCE;
        }
        postProcessors.sort((Comparator<?>)comparatorToUse);
    }

    private static void invokeBeanDefinitionRegistryPostProcessors(Collection<? extends BeanDefinitionRegistryPostProcessor> postProcessors, BeanDefinitionRegistry registry) {
        for (BeanDefinitionRegistryPostProcessor beanDefinitionRegistryPostProcessor : postProcessors) {
            beanDefinitionRegistryPostProcessor.postProcessBeanDefinitionRegistry(registry);
        }
    }

    private static void invokeBeanFactoryPostProcessors(Collection<? extends BeanFactoryPostProcessor> postProcessors, ConfigurableBeanFactory beanFactory) {
        for (BeanFactoryPostProcessor beanFactoryPostProcessor : postProcessors) {
            beanFactoryPostProcessor.postProcessBeanFactory(beanFactory);
        }
    }

    private static void registerBeanPostProcessors(ConfigurableBeanFactory beanFactory, List<BeanPostProcessor> postProcessors) {
        if (beanFactory instanceof AbstractBeanFactory) {
            AbstractBeanFactory abstractBeanFactory = (AbstractBeanFactory)beanFactory;
            abstractBeanFactory.addBeanPostProcessors(postProcessors);
        } else {
            for (BeanPostProcessor postProcessor : postProcessors) {
                beanFactory.addBeanPostProcessor(postProcessor);
            }
        }
    }

    private static final class BeanPostProcessorChecker
    implements InitializationBeanPostProcessor {
        private static final Logger log = LoggerFactory.getLogger(BeanPostProcessorChecker.class);
        private final ConfigurableBeanFactory beanFactory;
        private final int beanPostProcessorTargetCount;

        public BeanPostProcessorChecker(ConfigurableBeanFactory beanFactory, int count) {
            this.beanFactory = beanFactory;
            this.beanPostProcessorTargetCount = count;
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) {
            return bean;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) {
            if (!(bean instanceof BeanPostProcessor) && !this.isInfrastructureBean(beanName) && this.beanFactory.getBeanPostProcessorCount() < this.beanPostProcessorTargetCount) {
                log.info("Bean '{}' of type [{}] is not eligible for getting processed by all BeanPostProcessors (for example: not eligible for auto-proxying)", (Object)beanName, (Object)bean.getClass().getName());
            }
            return bean;
        }

        private boolean isInfrastructureBean(@Nullable String beanName) {
            if (beanName != null && this.beanFactory.containsBeanDefinition(beanName)) {
                BeanDefinition bd = this.beanFactory.getBeanDefinition(beanName);
                return bd.getRole() == 2;
            }
            return false;
        }
    }
}

