/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.support;

import cn.taketoday.beans.factory.annotation.AnnotatedGenericBeanDefinition;
import cn.taketoday.beans.factory.config.BeanDefinition;
import cn.taketoday.context.BootstrapContext;
import cn.taketoday.context.support.BeanDefinitionLoader;
import cn.taketoday.context.support.ContextUtils;
import cn.taketoday.core.type.AnnotatedTypeMetadata;
import cn.taketoday.core.type.AnnotationMetadata;
import cn.taketoday.core.type.classreading.MetadataReader;
import cn.taketoday.core.type.classreading.MetadataReaderFactory;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.util.ExceptionUtils;
import java.io.IOException;
import java.util.Set;

public class MetaInfoBeanDefinitionLoader
implements BeanDefinitionLoader {
    public static final String META_INFO_beans = "META-INF/beans";
    private static final Logger log = LoggerFactory.getLogger(MetaInfoBeanDefinitionLoader.class);

    @Override
    public void loadBeanDefinitions(BootstrapContext context) {
        try {
            this.loadMetaInfoBeans(context);
        }
        catch (IOException e) {
            throw ExceptionUtils.sneakyThrow((Throwable)e);
        }
    }

    public void loadMetaInfoBeans(BootstrapContext context) throws IOException {
        log.debug("Loading META-INF/beans");
        Set<String> beans = ContextUtils.loadFromMetaInfoClass(META_INFO_beans);
        MetadataReaderFactory metadataReaderFactory = context.getMetadataReaderFactory();
        for (String beanClassName : beans) {
            MetadataReader metadataReader = metadataReaderFactory.getMetadataReader(beanClassName);
            AnnotationMetadata annotationMetadata = metadataReader.getAnnotationMetadata();
            if (!context.passCondition((AnnotatedTypeMetadata)annotationMetadata)) continue;
            AnnotatedGenericBeanDefinition definition = new AnnotatedGenericBeanDefinition(annotationMetadata);
            definition.setResource(metadataReader.getResource());
            context.registerBeanDefinition(context.generateBeanName((BeanDefinition)definition), (BeanDefinition)definition);
        }
        log.debug("Found {} META-INF/beans", (Object)beans.size());
    }
}

