/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.support;

import cn.taketoday.beans.BeansException;
import cn.taketoday.beans.PropertyValues;
import cn.taketoday.beans.factory.config.AutowireCapableBeanFactory;
import cn.taketoday.beans.factory.config.BeanDefinition;
import cn.taketoday.beans.factory.config.BeanDefinitionCustomizer;
import cn.taketoday.beans.factory.support.BeanDefinitionRegistry;
import cn.taketoday.beans.factory.support.RootBeanDefinition;
import cn.taketoday.beans.factory.support.StandardBeanFactory;
import cn.taketoday.context.ApplicationContext;
import cn.taketoday.context.BootstrapContext;
import cn.taketoday.context.support.AbstractApplicationContext;
import cn.taketoday.core.io.PatternResourceLoader;
import cn.taketoday.core.io.ProtocolResolver;
import cn.taketoday.core.io.Resource;
import cn.taketoday.core.io.ResourceConsumer;
import cn.taketoday.core.io.ResourceLoader;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.CollectionUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;

public class GenericApplicationContext
extends AbstractApplicationContext
implements BeanDefinitionRegistry {
    protected final StandardBeanFactory beanFactory;
    @Nullable
    private ResourceLoader resourceLoader;
    private boolean customClassLoader = false;
    private final AtomicBoolean refreshed = new AtomicBoolean();

    public GenericApplicationContext() {
        this.beanFactory = new StandardBeanFactory();
    }

    public GenericApplicationContext(StandardBeanFactory beanFactory) {
        Assert.notNull((Object)beanFactory, (String)"BeanFactory must not be null");
        this.beanFactory = beanFactory;
    }

    public GenericApplicationContext(@Nullable ApplicationContext parent) {
        this();
        this.setParent(parent);
    }

    public GenericApplicationContext(StandardBeanFactory beanFactory, ApplicationContext parent) {
        this(beanFactory);
        this.setParent(parent);
    }

    @Override
    protected BootstrapContext createBootstrapContext() {
        return new BootstrapContext((BeanDefinitionRegistry)this.beanFactory, this);
    }

    @Override
    public void setParent(@Nullable ApplicationContext parent) {
        super.setParent(parent);
        this.beanFactory.setParentBeanFactory(this.getInternalParentBeanFactory());
    }

    @Override
    protected final void refreshBeanFactory() throws IllegalStateException {
        if (!this.refreshed.compareAndSet(false, true)) {
            throw new IllegalStateException("GenericApplicationContext does not support multiple refresh attempts: just call 'refresh' once");
        }
        this.beanFactory.setSerializationId(this.getId());
    }

    @Override
    protected void cancelRefresh(Exception ex) {
        this.beanFactory.setSerializationId(null);
        super.cancelRefresh(ex);
    }

    @Override
    protected final void closeBeanFactory() {
        this.beanFactory.setSerializationId(null);
    }

    public StandardBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    @Override
    public AutowireCapableBeanFactory getAutowireCapableBeanFactory() throws IllegalStateException {
        this.assertBeanFactoryActive();
        return this.beanFactory;
    }

    public void setResourceLoader(@Nullable ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public Resource getResource(String location) {
        if (this.resourceLoader != null) {
            Collection protocolResolvers = this.getProtocolResolvers();
            if (CollectionUtils.isNotEmpty((Collection)protocolResolvers)) {
                for (ProtocolResolver protocolResolver : protocolResolvers) {
                    Resource resource = protocolResolver.resolve(location, (ResourceLoader)this);
                    if (resource == null) continue;
                    return resource;
                }
            }
            return this.resourceLoader.getResource(location);
        }
        return super.getResource(location);
    }

    @Override
    public Set<Resource> getResources(String locationPattern) throws IOException {
        if (this.resourceLoader instanceof PatternResourceLoader) {
            return ((PatternResourceLoader)this.resourceLoader).getResources(locationPattern);
        }
        return super.getResources(locationPattern);
    }

    @Override
    public void scan(String locationPattern, ResourceConsumer consumer) throws IOException {
        if (this.resourceLoader instanceof PatternResourceLoader) {
            ((PatternResourceLoader)this.resourceLoader).scan(locationPattern, consumer);
        } else {
            super.scan(locationPattern, consumer);
        }
    }

    @Override
    public void setClassLoader(@Nullable ClassLoader classLoader) {
        super.setClassLoader(classLoader);
        this.customClassLoader = true;
    }

    @Nullable
    public ClassLoader getClassLoader() {
        if (this.resourceLoader != null && !this.customClassLoader) {
            return this.resourceLoader.getClassLoader();
        }
        return super.getClassLoader();
    }

    public void registerBeanDefinition(String name, BeanDefinition def) {
        this.beanFactory.registerBeanDefinition(name, def);
    }

    public void removeBeanDefinition(String beanName) {
        this.beanFactory.removeBeanDefinition(beanName);
    }

    public BeanDefinition getBeanDefinition(Class<?> beanClass) {
        return this.beanFactory.getBeanDefinition(beanClass);
    }

    public boolean containsBeanDefinition(Class<?> type) {
        return this.beanFactory.containsBeanDefinition(type);
    }

    public boolean containsBeanDefinition(Class<?> type, boolean equals) {
        return this.beanFactory.containsBeanDefinition(type, equals);
    }

    public boolean isBeanNameInUse(String beanName) {
        return this.beanFactory.isBeanNameInUse(beanName);
    }

    public boolean isAllowBeanDefinitionOverriding() {
        return this.beanFactory.isAllowBeanDefinitionOverriding();
    }

    @Override
    public int getBeanDefinitionCount() {
        return this.beanFactory.getBeanDefinitionCount();
    }

    @Override
    public String[] getBeanDefinitionNames() {
        return this.beanFactory.getBeanDefinitionNames();
    }

    @Override
    public boolean containsBeanDefinition(String beanName) {
        return this.beanFactory.containsBeanDefinition(beanName);
    }

    @Override
    public BeanDefinition getBeanDefinition(String beanName) {
        return this.beanFactory.getBeanDefinition(beanName);
    }

    public void registerSingleton(String name, Object obj) {
        this.getBeanFactory().registerSingleton(name, obj);
    }

    public void registerSingleton(String name, Class<?> clazz) throws BeansException {
        RootBeanDefinition bd = new RootBeanDefinition(clazz);
        this.getBeanFactory().registerBeanDefinition(name, (BeanDefinition)bd);
    }

    public void registerSingleton(String name, Class<?> clazz, @Nullable PropertyValues pvs) throws BeansException {
        RootBeanDefinition bd = new RootBeanDefinition(clazz);
        bd.setPropertyValues(pvs);
        this.getBeanFactory().registerBeanDefinition(name, (BeanDefinition)bd);
    }

    public void registerPrototype(String name, Class<?> clazz) throws BeansException {
        RootBeanDefinition bd = new RootBeanDefinition(clazz);
        bd.setScope("prototype");
        this.getBeanFactory().registerBeanDefinition(name, (BeanDefinition)bd);
    }

    public void registerPrototype(String name, Class<?> clazz, PropertyValues pvs) throws BeansException {
        RootBeanDefinition bd = new RootBeanDefinition(clazz);
        bd.setScope("prototype");
        bd.setPropertyValues(pvs);
        this.getBeanFactory().registerBeanDefinition(name, (BeanDefinition)bd);
    }

    public void registerSingleton(Object obj) {
        this.getBeanFactory().registerSingleton(obj);
    }

    public <T> void registerBean(Class<T> beanClass, Object ... constructorArgs) {
        this.registerBean(null, beanClass, constructorArgs);
    }

    public <T> void registerBean(@Nullable String beanName, Class<T> beanClass, Object ... constructorArgs) {
        this.registerBean(beanName, beanClass, (Supplier)null, bd -> {
            for (Object arg : constructorArgs) {
                bd.getConstructorArgumentValues().addGenericArgumentValue(arg);
            }
        });
    }

    public final <T> void registerBean(Class<T> beanClass, BeanDefinitionCustomizer ... customizers) {
        this.registerBean((String)null, beanClass, (Supplier<T>)null, customizers);
    }

    public final <T> void registerBean(@Nullable String beanName, Class<T> beanClass, BeanDefinitionCustomizer ... customizers) {
        this.registerBean(beanName, beanClass, (Supplier<T>)null, customizers);
    }

    public final <T> void registerBean(Class<T> beanClass, Supplier<T> supplier, BeanDefinitionCustomizer ... customizers) {
        this.registerBean(null, beanClass, supplier, customizers);
    }

    public <T> void registerBean(@Nullable String beanName, Class<T> beanClass, @Nullable Supplier<T> supplier, BeanDefinitionCustomizer ... customizers) {
        RootBeanDefinition beanDefinition = new RootBeanDefinition(beanClass);
        if (supplier != null) {
            beanDefinition.setInstanceSupplier(supplier);
        }
        for (BeanDefinitionCustomizer customizer : customizers) {
            customizer.customize((BeanDefinition)beanDefinition);
        }
        String nameToUse = beanName != null ? beanName : beanClass.getName();
        this.registerBeanDefinition(nameToUse, (BeanDefinition)beanDefinition);
    }

    public void registerAlias(String name, String alias) {
        this.beanFactory.registerAlias(name, alias);
    }

    public void removeAlias(String alias) {
        this.beanFactory.removeAlias(alias);
    }

    public boolean isAlias(String name) {
        return this.beanFactory.isAlias(name);
    }

    public List<String> getAliasList(String name) {
        return this.beanFactory.getAliasList(name);
    }

    public void setAllowBeanDefinitionOverriding(boolean allowBeanDefinitionOverriding) {
        this.beanFactory.setAllowBeanDefinitionOverriding(allowBeanDefinitionOverriding);
    }

    public void setAllowCircularReferences(boolean allowCircularReferences) {
        this.beanFactory.setAllowCircularReferences(allowCircularReferences);
    }
}

