/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.support;

import cn.taketoday.beans.factory.BeanFactory;
import cn.taketoday.beans.factory.BeanFactoryAware;
import cn.taketoday.beans.factory.BeanFactoryUtils;
import cn.taketoday.beans.factory.config.ConfigurableBeanFactory;
import cn.taketoday.context.ApplicationContextException;
import cn.taketoday.context.Lifecycle;
import cn.taketoday.context.LifecycleProcessor;
import cn.taketoday.context.Phased;
import cn.taketoday.context.SmartLifecycle;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class DefaultLifecycleProcessor
implements LifecycleProcessor,
BeanFactoryAware {
    private static final Logger log = LoggerFactory.getLogger(DefaultLifecycleProcessor.class);
    private volatile long timeoutPerShutdownPhase = 30000L;
    private volatile boolean running;
    @Nullable
    private volatile ConfigurableBeanFactory beanFactory;

    public void setTimeoutPerShutdownPhase(long timeoutPerShutdownPhase) {
        this.timeoutPerShutdownPhase = timeoutPerShutdownPhase;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        if (!(beanFactory instanceof ConfigurableBeanFactory)) {
            throw new IllegalArgumentException("DefaultLifecycleProcessor requires a ConfigurableBeanFactory: " + beanFactory);
        }
        this.beanFactory = (ConfigurableBeanFactory)beanFactory;
    }

    private ConfigurableBeanFactory getBeanFactory() {
        ConfigurableBeanFactory beanFactory = this.beanFactory;
        Assert.state((beanFactory != null ? 1 : 0) != 0, (String)"No BeanFactory available");
        return beanFactory;
    }

    @Override
    public void start() {
        this.startBeans(false);
        this.running = true;
    }

    @Override
    public void stop() {
        this.stopBeans();
        this.running = false;
    }

    @Override
    public void onRefresh() {
        this.startBeans(true);
        this.running = true;
    }

    @Override
    public void onClose() {
        this.stopBeans();
        this.running = false;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    private void startBeans(boolean autoStartupOnly) {
        Map<String, Lifecycle> lifecycleBeans = this.getLifecycleBeans();
        TreeMap<Integer, LifecycleGroup> phases = new TreeMap<Integer, LifecycleGroup>();
        for (Map.Entry<String, Lifecycle> entry : lifecycleBeans.entrySet()) {
            SmartLifecycle smartLifecycle;
            String beanName = entry.getKey();
            Lifecycle bean = entry.getValue();
            if (autoStartupOnly && (!(bean instanceof SmartLifecycle) || !(smartLifecycle = (SmartLifecycle)bean).isAutoStartup())) continue;
            int phase = this.getPhase(bean);
            LifecycleGroup lifecycleGroup = (LifecycleGroup)phases.get(phase);
            if (lifecycleGroup == null) {
                lifecycleGroup = new LifecycleGroup(phase, this.timeoutPerShutdownPhase, lifecycleBeans, autoStartupOnly);
                phases.put(phase, lifecycleGroup);
            }
            lifecycleGroup.add(beanName, bean);
        }
        if (!phases.isEmpty()) {
            for (LifecycleGroup group : phases.values()) {
                group.start();
            }
        }
    }

    private void doStart(Map<String, ? extends Lifecycle> lifecycleBeans, String beanName, boolean autoStartupOnly) {
        Lifecycle bean = lifecycleBeans.remove(beanName);
        if (bean != null && bean != this) {
            SmartLifecycle smartLifecycle;
            String[] dependenciesForBean;
            for (String dependency : dependenciesForBean = this.getBeanFactory().getDependenciesForBean(beanName)) {
                this.doStart(lifecycleBeans, dependency, autoStartupOnly);
            }
            if (!(bean.isRunning() || autoStartupOnly && bean instanceof SmartLifecycle && !(smartLifecycle = (SmartLifecycle)bean).isAutoStartup())) {
                if (log.isTraceEnabled()) {
                    log.trace("Starting bean '{}' of type [{}]", (Object)beanName, (Object)bean.getClass().getName());
                }
                try {
                    bean.start();
                }
                catch (Throwable ex) {
                    throw new ApplicationContextException("Failed to start bean '" + beanName + "'", ex);
                }
                log.debug("Successfully started bean '{}'", (Object)beanName);
            }
        }
    }

    private void stopBeans() {
        Map<String, Lifecycle> lifecycleBeans = this.getLifecycleBeans();
        TreeMap phases = new TreeMap(Comparator.reverseOrder());
        for (Map.Entry<String, Lifecycle> entry : lifecycleBeans.entrySet()) {
            String beanName = entry.getKey();
            Lifecycle bean = entry.getValue();
            int shutdownPhase = this.getPhase(bean);
            LifecycleGroup group = (LifecycleGroup)phases.get(shutdownPhase);
            if (group == null) {
                group = new LifecycleGroup(shutdownPhase, this.timeoutPerShutdownPhase, lifecycleBeans, false);
                phases.put(shutdownPhase, group);
            }
            group.add(beanName, bean);
        }
        if (!phases.isEmpty()) {
            for (LifecycleGroup group : phases.values()) {
                group.stop();
            }
        }
    }

    private void doStop(Map<String, ? extends Lifecycle> lifecycleBeans, String beanName, CountDownLatch latch, Set<String> countDownBeanNames) {
        Lifecycle bean = lifecycleBeans.remove(beanName);
        if (bean != null) {
            String[] dependentBeans;
            for (String dependentBean : dependentBeans = this.getBeanFactory().getDependentBeans(beanName)) {
                this.doStop(lifecycleBeans, dependentBean, latch, countDownBeanNames);
            }
            try {
                if (bean.isRunning()) {
                    if (bean instanceof SmartLifecycle) {
                        SmartLifecycle smartLifecycle = (SmartLifecycle)bean;
                        if (log.isTraceEnabled()) {
                            log.trace("Asking bean '{}' of type [{}] to stop", (Object)beanName, (Object)bean.getClass().getName());
                        }
                        countDownBeanNames.add(beanName);
                        smartLifecycle.stop(() -> {
                            latch.countDown();
                            countDownBeanNames.remove(beanName);
                            log.debug("Bean '{}' completed its stop procedure", (Object)beanName);
                        });
                    } else {
                        if (log.isTraceEnabled()) {
                            log.trace("Stopping bean '{}' of type [{}]", (Object)beanName, (Object)bean.getClass().getName());
                        }
                        bean.stop();
                        log.debug("Successfully stopped bean '{}'", (Object)beanName);
                    }
                } else if (bean instanceof SmartLifecycle) {
                    latch.countDown();
                }
            }
            catch (Throwable ex) {
                log.warn("Failed to stop bean '{}'", (Object)beanName, (Object)ex);
            }
        }
    }

    protected Map<String, Lifecycle> getLifecycleBeans() {
        ConfigurableBeanFactory beanFactory = this.getBeanFactory();
        LinkedHashMap<String, Lifecycle> beans = new LinkedHashMap<String, Lifecycle>();
        Set beanNames = beanFactory.getBeanNamesForType(Lifecycle.class, false, false);
        for (String beanName : beanNames) {
            Object bean;
            Object beanNameToCheck;
            String beanNameToRegister = BeanFactoryUtils.transformedBeanName((String)beanName);
            boolean isFactoryBean = beanFactory.isFactoryBean(beanNameToRegister);
            Object object = beanNameToCheck = isFactoryBean ? "&" + beanName : beanName;
            if ((!beanFactory.containsSingleton(beanNameToRegister) || isFactoryBean && !this.matchesBeanType(Lifecycle.class, (String)beanNameToCheck, (BeanFactory)beanFactory)) && !this.matchesBeanType(SmartLifecycle.class, (String)beanNameToCheck, (BeanFactory)beanFactory) || (bean = beanFactory.getBean((String)beanNameToCheck)) == this || !(bean instanceof Lifecycle)) continue;
            beans.put(beanNameToRegister, (Lifecycle)bean);
        }
        return beans;
    }

    private boolean matchesBeanType(Class<?> targetType, String beanName, BeanFactory beanFactory) {
        Class beanType = beanFactory.getType(beanName);
        return beanType != null && targetType.isAssignableFrom(beanType);
    }

    protected int getPhase(Lifecycle bean) {
        return bean instanceof Phased ? ((Phased)((Object)bean)).getPhase() : 0;
    }

    private class LifecycleGroup {
        private final int phase;
        private final long timeout;
        private int smartMemberCount;
        private final boolean autoStartupOnly;
        private final Map<String, ? extends Lifecycle> lifecycleBeans;
        private final ArrayList<LifecycleGroupMember> members = new ArrayList();

        public LifecycleGroup(int phase, long timeout, Map<String, ? extends Lifecycle> lifecycleBeans, boolean autoStartupOnly) {
            this.phase = phase;
            this.timeout = timeout;
            this.lifecycleBeans = lifecycleBeans;
            this.autoStartupOnly = autoStartupOnly;
        }

        public void add(String name, Lifecycle bean) {
            this.members.add(new LifecycleGroupMember(name, bean));
            if (bean instanceof SmartLifecycle) {
                ++this.smartMemberCount;
            }
        }

        public void start() {
            if (this.members.isEmpty()) {
                return;
            }
            log.debug("Starting beans in phase {}", (Object)this.phase);
            for (LifecycleGroupMember member : this.members) {
                DefaultLifecycleProcessor.this.doStart(this.lifecycleBeans, member.name, this.autoStartupOnly);
            }
        }

        public void stop() {
            if (this.members.isEmpty()) {
                return;
            }
            log.debug("Stopping beans in phase {}", (Object)this.phase);
            CountDownLatch latch = new CountDownLatch(this.smartMemberCount);
            Set<String> countDownBeanNames = Collections.synchronizedSet(new LinkedHashSet());
            HashSet<String> lifecycleBeanNames = new HashSet<String>(this.lifecycleBeans.keySet());
            for (LifecycleGroupMember member : this.members) {
                if (lifecycleBeanNames.contains(member.name)) {
                    DefaultLifecycleProcessor.this.doStop(this.lifecycleBeans, member.name, latch, countDownBeanNames);
                    continue;
                }
                if (!(member.bean instanceof SmartLifecycle)) continue;
                latch.countDown();
            }
            try {
                latch.await(this.timeout, TimeUnit.MILLISECONDS);
                if (latch.getCount() > 0L && !countDownBeanNames.isEmpty() && log.isInfoEnabled()) {
                    log.info("Failed to shut down {} bean {} with phase value {} within timeout of {}ms: {}", new Object[]{countDownBeanNames.size(), countDownBeanNames.size() > 1 ? "s" : "", this.phase, this.timeout, countDownBeanNames});
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private record LifecycleGroupMember(String name, Lifecycle bean) {
    }
}

