/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.support;

import cn.taketoday.beans.factory.BeanFactory;
import cn.taketoday.beans.factory.support.BeanFactoryAwareInstantiator;
import cn.taketoday.beans.factory.support.DependencyInjectorProvider;
import cn.taketoday.context.ApplicationContextException;
import cn.taketoday.context.support.ApplicationContextHolder;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Constant;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class ContextUtils {
    public static Set<Class<?>> loadFromMetaInfo(String resource) {
        Assert.notNull((Object)resource, (String)"META-INF resource must not be null");
        if (resource.startsWith("META-INF")) {
            HashSet ret = new HashSet();
            ClassLoader classLoader = ClassUtils.getDefaultClassLoader();
            if (classLoader == null) {
                classLoader = ContextUtils.class.getClassLoader();
            }
            Charset charset = Constant.DEFAULT_CHARSET;
            try {
                Enumeration<URL> resources = classLoader.getResources(resource);
                while (resources.hasMoreElements()) {
                    URL url = resources.nextElement();
                    String className = null;
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), charset));){
                        while ((className = reader.readLine()) != null) {
                            if (!StringUtils.isNotEmpty((CharSequence)className)) continue;
                            ret.add(classLoader.loadClass(className));
                        }
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalStateException("Class file: '" + className + "' not in " + url);
                    }
                }
                return ret;
            }
            catch (IOException e) {
                throw new ApplicationContextException("Exception occurred when load from '" + resource + "'", e);
            }
        }
        throw new IllegalArgumentException("Resource must start with 'META-INF'");
    }

    public static Set<String> loadFromMetaInfoClass(String resource) {
        Assert.notNull((Object)resource, (String)"META-INF resource must not be null");
        if (resource.startsWith("META-INF")) {
            LinkedHashSet<String> ret = new LinkedHashSet<String>();
            ClassLoader classLoader = ClassUtils.getDefaultClassLoader();
            if (classLoader == null) {
                classLoader = ContextUtils.class.getClassLoader();
            }
            try {
                Enumeration<URL> resources = classLoader.getResources(resource);
                while (resources.hasMoreElements()) {
                    URL url = resources.nextElement();
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), Constant.DEFAULT_CHARSET));){
                        String className;
                        while ((className = reader.readLine()) != null) {
                            if (!StringUtils.isNotEmpty((CharSequence)className)) continue;
                            ret.add(className);
                        }
                    }
                }
                return ret;
            }
            catch (IOException e) {
                throw new ApplicationContextException("Exception occurred when load from '" + resource + "'", e);
            }
        }
        throw new IllegalArgumentException("Resource must start with 'META-INF'");
    }

    public static <T> Set<T> loadBeansFromMetaInfo(String resource) {
        return ContextUtils.loadBeansFromMetaInfo(resource, (BeanFactory)ApplicationContextHolder.getLastStartupContext());
    }

    public static <T> Set<T> loadBeansFromMetaInfo(String resource, BeanFactory beanFactory) {
        Set<Class<?>> classes = ContextUtils.loadFromMetaInfo(resource);
        HashSet<Object> ret = new HashSet<Object>();
        for (Class<?> aClass : classes) {
            Object obj = BeanFactoryAwareInstantiator.instantiate(aClass, (DependencyInjectorProvider)beanFactory);
            ret.add(obj);
        }
        return ret;
    }
}

