/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.support;

import cn.taketoday.beans.BeansException;
import cn.taketoday.beans.factory.Aware;
import cn.taketoday.beans.factory.InitializationBeanPostProcessor;
import cn.taketoday.beans.factory.config.EmbeddedValueResolver;
import cn.taketoday.context.ApplicationContextAware;
import cn.taketoday.context.ApplicationEventPublisherAware;
import cn.taketoday.context.BootstrapContext;
import cn.taketoday.context.BootstrapContextAware;
import cn.taketoday.context.ConfigurableApplicationContext;
import cn.taketoday.context.EnvironmentAware;
import cn.taketoday.context.MessageSourceAware;
import cn.taketoday.context.ResourceLoaderAware;
import cn.taketoday.context.expression.EmbeddedValueResolverAware;
import cn.taketoday.core.StringValueResolver;
import cn.taketoday.core.env.Environment;
import cn.taketoday.core.io.ResourceLoader;
import cn.taketoday.lang.Nullable;

final class ContextAwareProcessor
implements InitializationBeanPostProcessor {
    private final ConfigurableApplicationContext context;
    private final EmbeddedValueResolver embeddedValueResolver;
    private final BootstrapContext bootstrapContext;

    ContextAwareProcessor(ConfigurableApplicationContext applicationContext, BootstrapContext bootstrapContext) {
        this.context = applicationContext;
        this.embeddedValueResolver = new EmbeddedValueResolver(applicationContext.getBeanFactory());
        this.bootstrapContext = bootstrapContext;
    }

    @Nullable
    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof Aware) {
            this.awareInternal(bean);
        }
        return bean;
    }

    private void awareInternal(Object bean) {
        Object aware;
        if (bean instanceof BootstrapContextAware) {
            aware = (BootstrapContextAware)bean;
            aware.setBootstrapContext(this.bootstrapContext);
        }
        if (bean instanceof EnvironmentAware) {
            aware = (EnvironmentAware)bean;
            aware.setEnvironment((Environment)this.context.getEnvironment());
        }
        if (bean instanceof ResourceLoaderAware) {
            aware = (ResourceLoaderAware)bean;
            aware.setResourceLoader((ResourceLoader)this.context);
        }
        if (bean instanceof ApplicationEventPublisherAware) {
            aware = (ApplicationEventPublisherAware)bean;
            aware.setApplicationEventPublisher(this.context);
        }
        if (bean instanceof ApplicationContextAware) {
            aware = (ApplicationContextAware)bean;
            aware.setApplicationContext(this.context);
        }
        if (bean instanceof MessageSourceAware) {
            aware = (MessageSourceAware)bean;
            aware.setMessageSource(this.context);
        }
        if (bean instanceof EmbeddedValueResolverAware) {
            aware = (EmbeddedValueResolverAware)bean;
            aware.setEmbeddedValueResolver((StringValueResolver)this.embeddedValueResolver);
        }
    }
}

