/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.support;

import cn.taketoday.beans.BeansException;
import cn.taketoday.context.ApplicationContext;
import cn.taketoday.context.ApplicationContextAware;
import cn.taketoday.context.ApplicationContextException;
import cn.taketoday.context.support.MessageSourceAccessor;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;

public abstract class ApplicationContextSupport
implements ApplicationContextAware {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    @Nullable
    protected ApplicationContext applicationContext;
    @Nullable
    protected MessageSourceAccessor messageSourceAccessor;

    @Override
    public final void setApplicationContext(@Nullable ApplicationContext context) throws BeansException {
        if (context == null && !this.isContextRequired()) {
            this.applicationContext = null;
            this.messageSourceAccessor = null;
        } else if (this.applicationContext == null) {
            if (!this.requiredContextClass().isInstance(context)) {
                throw new ApplicationContextException("Invalid application context: needs to be of type [" + this.requiredContextClass().getName() + "]");
            }
            this.applicationContext = context;
            this.messageSourceAccessor = new MessageSourceAccessor(context);
            this.initApplicationContext(context);
        } else if (this.applicationContext != context) {
            throw new ApplicationContextException("Cannot reinitialize with different application context: current one is [" + this.applicationContext + "], passed-in one is [" + context + "]");
        }
    }

    protected void initApplicationContext(ApplicationContext context) {
        this.initApplicationContext();
    }

    protected void initApplicationContext() {
    }

    @Nullable
    public final ApplicationContext getApplicationContext() throws IllegalStateException {
        ApplicationContext context = this.applicationContext;
        if (context == null && this.isContextRequired()) {
            throw new IllegalStateException("ApplicationContextSupport instance [" + this + "] does not run in an ApplicationContext");
        }
        return context;
    }

    public ApplicationContext obtainApplicationContext() {
        ApplicationContext context = this.applicationContext;
        Assert.state((context != null ? 1 : 0) != 0, (String)"No ApplicationContext");
        return context;
    }

    public <T> T unwrapFactory(Class<T> requiredType) {
        return this.obtainApplicationContext().unwrapFactory(requiredType);
    }

    public <T> T unwrapContext(Class<T> requiredType) {
        return (T)this.obtainApplicationContext().unwrap(requiredType);
    }

    @Nullable
    protected final MessageSourceAccessor getMessageSourceAccessor() throws IllegalStateException {
        MessageSourceAccessor accessor = this.messageSourceAccessor;
        if (accessor == null && this.isContextRequired()) {
            throw new IllegalStateException("ApplicationObjectSupport instance [" + this + "] does not run in an ApplicationContext");
        }
        return accessor;
    }

    protected boolean isContextRequired() {
        return false;
    }

    protected Class<?> requiredContextClass() {
        return ApplicationContext.class;
    }
}

