/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.support;

import cn.taketoday.context.ApplicationContext;
import cn.taketoday.lang.Nullable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Optional;

public final class ApplicationContextHolder {
    private static final LinkedHashMap<String, ApplicationContext> contextMap = new LinkedHashMap();

    @Nullable
    public static ApplicationContext get(String id) {
        return contextMap.get(id);
    }

    public static Optional<ApplicationContext> optional(String id) {
        return Optional.ofNullable(contextMap.get(id));
    }

    public static ApplicationContext getRequired(String id) {
        ApplicationContext context = ApplicationContextHolder.get(id);
        if (context == null) {
            throw new IllegalStateException("No ApplicationContext: '" + id + "'");
        }
        return context;
    }

    @Nullable
    public static ApplicationContext register(String id, ApplicationContext context) {
        return contextMap.put(id, context);
    }

    @Nullable
    public static ApplicationContext register(ApplicationContext context) {
        return contextMap.put(context.getId(), context);
    }

    @Nullable
    public static ApplicationContext remove(String id) {
        return (ApplicationContext)contextMap.remove(id);
    }

    public static void remove(ApplicationContext context) {
        contextMap.remove(context.getId());
    }

    @Nullable
    public static ApplicationContext getLastStartupContext() {
        if (contextMap.isEmpty()) {
            return null;
        }
        return contextMap.values().iterator().next();
    }

    public static HashMap<String, ApplicationContext> getAll() {
        return contextMap;
    }
}

