/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.support;

import cn.taketoday.beans.BeansException;
import cn.taketoday.beans.factory.config.BeanDefinition;
import cn.taketoday.beans.factory.support.BeanDefinitionRegistry;
import cn.taketoday.beans.factory.support.StandardBeanFactory;
import cn.taketoday.context.ApplicationContext;
import cn.taketoday.context.ApplicationContextException;
import cn.taketoday.context.BootstrapContext;
import cn.taketoday.context.support.AbstractApplicationContext;
import cn.taketoday.lang.Nullable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class AbstractRefreshableApplicationContext
extends AbstractApplicationContext
implements BeanDefinitionRegistry {
    @Nullable
    private Boolean allowBeanDefinitionOverriding;
    @Nullable
    private Boolean allowCircularReferences;
    @Nullable
    private volatile StandardBeanFactory beanFactory;

    public AbstractRefreshableApplicationContext() {
    }

    public AbstractRefreshableApplicationContext(@Nullable ApplicationContext parent) {
        super(parent);
    }

    @Override
    protected BootstrapContext createBootstrapContext() {
        return new BootstrapContext(Objects.requireNonNullElse(this.beanFactory, this), this);
    }

    public void setAllowBeanDefinitionOverriding(boolean allowBeanDefinitionOverriding) {
        this.allowBeanDefinitionOverriding = allowBeanDefinitionOverriding;
    }

    public void setAllowCircularReferences(boolean allowCircularReferences) {
        this.allowCircularReferences = allowCircularReferences;
    }

    @Override
    protected final void refreshBeanFactory() throws BeansException {
        if (this.hasBeanFactory()) {
            this.destroyBeans();
            this.closeBeanFactory();
        }
        try {
            StandardBeanFactory beanFactory = this.createBeanFactory();
            beanFactory.setSerializationId(this.getId());
            this.customizeBeanFactory(beanFactory);
            this.loadBeanDefinitions(beanFactory);
            this.beanFactory = beanFactory;
        }
        catch (IOException ex) {
            throw new ApplicationContextException("I/O error parsing bean definition source for " + this.getDisplayName(), ex);
        }
    }

    @Override
    protected void cancelRefresh(Exception ex) {
        StandardBeanFactory beanFactory = this.beanFactory;
        if (beanFactory != null) {
            beanFactory.setSerializationId(null);
        }
        super.cancelRefresh(ex);
    }

    @Override
    protected final void closeBeanFactory() {
        StandardBeanFactory beanFactory = this.beanFactory;
        if (beanFactory != null) {
            beanFactory.setSerializationId(null);
            this.beanFactory = null;
        }
        this.setBootstrapContext(null);
    }

    protected final boolean hasBeanFactory() {
        return this.beanFactory != null;
    }

    public final StandardBeanFactory getBeanFactory() {
        StandardBeanFactory beanFactory = this.beanFactory;
        if (beanFactory == null) {
            throw new IllegalStateException("BeanFactory not initialized or already closed - call 'refresh' before accessing beans via the ApplicationContext");
        }
        return beanFactory;
    }

    @Override
    protected void assertBeanFactoryActive() {
    }

    protected StandardBeanFactory createBeanFactory() {
        return new StandardBeanFactory(this.getInternalParentBeanFactory());
    }

    protected void customizeBeanFactory(StandardBeanFactory beanFactory) {
        if (this.allowBeanDefinitionOverriding != null) {
            beanFactory.setAllowBeanDefinitionOverriding(this.allowBeanDefinitionOverriding.booleanValue());
        }
        if (this.allowCircularReferences != null) {
            beanFactory.setAllowCircularReferences(this.allowCircularReferences.booleanValue());
        }
    }

    protected abstract void loadBeanDefinitions(StandardBeanFactory var1) throws BeansException, IOException;

    @Override
    public Map<String, BeanDefinition> getBeanDefinitions() {
        return this.getBeanFactory().getBeanDefinitions();
    }

    public void registerBeanDefinition(String beanName, BeanDefinition def) {
        this.getBeanFactory().registerBeanDefinition(beanName, def);
    }

    public void removeBeanDefinition(String beanName) {
        this.getBeanFactory().removeBeanDefinition(beanName);
    }

    @Override
    @Nullable
    public BeanDefinition getBeanDefinition(String beanName) {
        return this.getBeanFactory().getBeanDefinition(beanName);
    }

    @Nullable
    public BeanDefinition getBeanDefinition(Class<?> requiredType) {
        return this.getBeanFactory().getBeanDefinition(requiredType);
    }

    public boolean containsBeanDefinition(Class<?> type) {
        return this.getBeanFactory().containsBeanDefinition(type);
    }

    public boolean containsBeanDefinition(Class<?> type, boolean equals) {
        return this.getBeanFactory().containsBeanDefinition(type, equals);
    }

    public boolean containsBeanDefinition(String beanName, Class<?> type) {
        return this.getBeanFactory().containsBeanDefinition(beanName, type);
    }

    @Override
    public boolean containsBeanDefinition(String beanName) {
        return this.getBeanFactory().containsBeanDefinition(beanName);
    }

    @Override
    public String[] getBeanDefinitionNames() {
        return this.getBeanFactory().getBeanDefinitionNames();
    }

    @Override
    public int getBeanDefinitionCount() {
        return this.getBeanFactory().getBeanDefinitionCount();
    }

    public boolean isAllowBeanDefinitionOverriding() {
        return this.getBeanFactory().isAllowBeanDefinitionOverriding();
    }

    public void registerAlias(String name, String alias) {
        this.getBeanFactory().registerAlias(name, alias);
    }

    public void removeAlias(String alias) {
        this.getBeanFactory().removeAlias(alias);
    }

    public boolean isAlias(String name) {
        return this.getBeanFactory().isAlias(name);
    }

    public List<String> getAliasList(String name) {
        return this.getBeanFactory().getAliasList(name);
    }

    public boolean isBeanNameInUse(String beanName) {
        return this.getBeanFactory().isBeanNameInUse(beanName);
    }
}

