/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.support;

import cn.taketoday.beans.BeansException;
import cn.taketoday.beans.CachedIntrospectionResults;
import cn.taketoday.beans.PropertyEditorRegistrar;
import cn.taketoday.beans.factory.BeanFactory;
import cn.taketoday.beans.factory.NoSuchBeanDefinitionException;
import cn.taketoday.beans.factory.ObjectProvider;
import cn.taketoday.beans.factory.config.AutowireCapableBeanFactory;
import cn.taketoday.beans.factory.config.BeanDefinition;
import cn.taketoday.beans.factory.config.BeanExpressionResolver;
import cn.taketoday.beans.factory.config.BeanFactoryPostProcessor;
import cn.taketoday.beans.factory.config.BeanPostProcessor;
import cn.taketoday.beans.factory.config.ConfigurableBeanFactory;
import cn.taketoday.beans.factory.config.ExpressionEvaluator;
import cn.taketoday.beans.factory.support.BeanFactoryAwareInstantiator;
import cn.taketoday.beans.factory.support.DependencyInjector;
import cn.taketoday.beans.support.ResourceEditorRegistrar;
import cn.taketoday.context.ApplicationContext;
import cn.taketoday.context.ApplicationContextAware;
import cn.taketoday.context.ApplicationContextException;
import cn.taketoday.context.ApplicationEvent;
import cn.taketoday.context.ApplicationEventPublisher;
import cn.taketoday.context.ApplicationEventPublisherAware;
import cn.taketoday.context.ApplicationListener;
import cn.taketoday.context.BootstrapContext;
import cn.taketoday.context.BootstrapContextAware;
import cn.taketoday.context.ConfigurableApplicationContext;
import cn.taketoday.context.EnvironmentAware;
import cn.taketoday.context.HierarchicalMessageSource;
import cn.taketoday.context.LifecycleProcessor;
import cn.taketoday.context.MessageSource;
import cn.taketoday.context.MessageSourceAware;
import cn.taketoday.context.MessageSourceResolvable;
import cn.taketoday.context.NoSuchMessageException;
import cn.taketoday.context.PayloadApplicationEvent;
import cn.taketoday.context.ResourceLoaderAware;
import cn.taketoday.context.event.ApplicationEventMulticaster;
import cn.taketoday.context.event.ContextClosedEvent;
import cn.taketoday.context.event.ContextRefreshedEvent;
import cn.taketoday.context.event.ContextStartedEvent;
import cn.taketoday.context.event.ContextStoppedEvent;
import cn.taketoday.context.event.SimpleApplicationEventMulticaster;
import cn.taketoday.context.expression.EmbeddedValueResolverAware;
import cn.taketoday.context.expression.StandardBeanExpressionResolver;
import cn.taketoday.context.support.ApplicationContextHolder;
import cn.taketoday.context.support.ApplicationListenerDetector;
import cn.taketoday.context.support.BeanDefinitionLoader;
import cn.taketoday.context.support.ContextAwareProcessor;
import cn.taketoday.context.support.ContextTypeMatchClassLoader;
import cn.taketoday.context.support.DefaultLifecycleProcessor;
import cn.taketoday.context.support.DelegatingMessageSource;
import cn.taketoday.context.support.PostProcessorRegistrationDelegate;
import cn.taketoday.context.weaving.LoadTimeWeaverAware;
import cn.taketoday.context.weaving.LoadTimeWeaverAwareProcessor;
import cn.taketoday.core.ResolvableType;
import cn.taketoday.core.annotation.AnnotationUtils;
import cn.taketoday.core.annotation.MergedAnnotation;
import cn.taketoday.core.conversion.ConversionService;
import cn.taketoday.core.env.ConfigurableEnvironment;
import cn.taketoday.core.env.Environment;
import cn.taketoday.core.env.PropertyResolver;
import cn.taketoday.core.env.StandardEnvironment;
import cn.taketoday.core.io.DefaultResourceLoader;
import cn.taketoday.core.io.PathMatchingPatternResourceLoader;
import cn.taketoday.core.io.PatternResourceLoader;
import cn.taketoday.core.io.Resource;
import cn.taketoday.core.io.ResourceConsumer;
import cn.taketoday.core.io.ResourceLoader;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.lang.TodayStrategies;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.util.CollectionUtils;
import cn.taketoday.util.ObjectUtils;
import cn.taketoday.util.ReflectionUtils;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractApplicationContext
extends DefaultResourceLoader
implements ConfigurableApplicationContext {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String APPLICATION_EVENT_MULTICASTER_BEAN_NAME = "applicationEventMulticaster";
    public static final String MESSAGE_SOURCE_BEAN_NAME = "messageSource";
    public static final String LIFECYCLE_PROCESSOR_BEAN_NAME = "lifecycleProcessor";
    private long startupDate;
    private ConfigurableEnvironment environment;
    private ApplicationContext.State state = ApplicationContext.State.NONE;
    private final ArrayList<BeanFactoryPostProcessor> factoryPostProcessors = new ArrayList();
    private String id = ObjectUtils.identityToString((Object)this);
    private String displayName = ObjectUtils.identityToString((Object)this);
    @Nullable
    private ApplicationContext parent;
    private final PatternResourceLoader patternResourceLoader = this.getPatternResourceLoader();
    private ExpressionEvaluator expressionEvaluator;
    @Nullable
    private Thread shutdownHook;
    @Nullable
    private LifecycleProcessor lifecycleProcessor;
    @Nullable
    private ApplicationEventMulticaster applicationEventMulticaster;
    private final LinkedHashSet<ApplicationListener<?>> applicationListeners = new LinkedHashSet();
    @Nullable
    private Set<ApplicationListener<?>> earlyApplicationListeners;
    @Nullable
    private Set<ApplicationEvent> earlyApplicationEvents;
    @Nullable
    private MessageSource messageSource;
    @Nullable
    private BootstrapContext bootstrapContext;
    private final AtomicBoolean active = new AtomicBoolean();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final Object startupShutdownMonitor = new Object();

    public AbstractApplicationContext() {
    }

    public AbstractApplicationContext(@Nullable ApplicationContext parent) {
        this();
        this.setParent(parent);
    }

    protected abstract BootstrapContext createBootstrapContext();

    public void setBootstrapContext(@Nullable BootstrapContext bootstrapContext) {
        this.bootstrapContext = bootstrapContext;
    }

    @Nullable
    public BootstrapContext getBootstrapContext() {
        return this.bootstrapContext;
    }

    protected final BootstrapContext obtainBootstrapContext() {
        BootstrapContext bootstrapContext = this.getBootstrapContext();
        if (bootstrapContext == null) {
            bootstrapContext = this.createBootstrapContext();
            this.setBootstrapContext(bootstrapContext);
        }
        return bootstrapContext;
    }

    public Set<Resource> getResources(String locationPattern) throws IOException {
        return this.patternResourceLoader.getResources(locationPattern);
    }

    public void scan(String locationPattern, ResourceConsumer consumer) throws IOException {
        this.patternResourceLoader.scan(locationPattern, consumer);
    }

    protected PatternResourceLoader getPatternResourceLoader() {
        return new PathMatchingPatternResourceLoader((ResourceLoader)this);
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getApplicationName() {
        return "";
    }

    public void setDisplayName(String displayName) {
        Assert.hasLength((String)displayName, (String)"Display name must not be empty");
        this.displayName = displayName;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @Nullable
    public ApplicationContext getParent() {
        return this.parent;
    }

    @Override
    public AutowireCapableBeanFactory getAutowireCapableBeanFactory() {
        return this.getBeanFactory();
    }

    @Override
    public ExpressionEvaluator getExpressionEvaluator() {
        if (this.expressionEvaluator == null) {
            this.expressionEvaluator = new ExpressionEvaluator(this.getBeanFactory());
        }
        return this.expressionEvaluator;
    }

    @Nullable
    public BeanFactory getParentBeanFactory() {
        return this.getParent();
    }

    public boolean containsLocalBean(String name) {
        return this.getBeanFactory().containsLocalBean(name);
    }

    @Nullable
    protected BeanFactory getInternalParentBeanFactory() {
        ApplicationContext applicationContext;
        ApplicationContext parent = this.getParent();
        if (parent instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext cac = (ConfigurableApplicationContext)parent;
            applicationContext = cac.getBeanFactory();
        } else {
            applicationContext = parent;
        }
        return applicationContext;
    }

    @Override
    public String getMessage(String code, @Nullable Object[] args, @Nullable String defaultMessage, Locale locale) {
        return this.getMessageSource().getMessage(code, args, defaultMessage, locale);
    }

    @Override
    public String getMessage(String code, @Nullable Object[] args, Locale locale) throws NoSuchMessageException {
        return this.getMessageSource().getMessage(code, args, locale);
    }

    @Override
    public String getMessage(MessageSourceResolvable resolvable, Locale locale) throws NoSuchMessageException {
        return this.getMessageSource().getMessage(resolvable, locale);
    }

    private MessageSource getMessageSource() throws IllegalStateException {
        if (this.messageSource == null) {
            throw new IllegalStateException("MessageSource not initialized - call 'refresh' before accessing messages via the context: " + this);
        }
        return this.messageSource;
    }

    @Nullable
    protected MessageSource getInternalParentMessageSource() {
        MessageSource messageSource;
        ApplicationContext parent = this.getParent();
        if (parent instanceof AbstractApplicationContext) {
            AbstractApplicationContext abc = (AbstractApplicationContext)parent;
            messageSource = abc.messageSource;
        } else {
            messageSource = parent;
        }
        return messageSource;
    }

    protected void resetCommonCaches() {
        ReflectionUtils.clearCache();
        AnnotationUtils.clearCache();
        ResolvableType.clearCache();
        CachedIntrospectionResults.clearClassLoader((ClassLoader)this.getClassLoader());
        if (this.bootstrapContext != null) {
            this.bootstrapContext.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() throws BeansException, IllegalStateException {
        Object object = this.startupShutdownMonitor;
        synchronized (object) {
            this.prepareRefresh();
            ConfigurableBeanFactory beanFactory = this.obtainFreshBeanFactory();
            this.registerFrameworkComponents(beanFactory);
            this.prepareBeanFactory(beanFactory);
            try {
                this.postProcessBeanFactory(beanFactory);
                this.invokeBeanFactoryPostProcessors(beanFactory);
                this.registerBeanPostProcessors(beanFactory);
                this.initMessageSource();
                this.initApplicationEventMulticaster();
                this.onRefresh();
                this.registerApplicationListeners();
                this.finishBeanFactoryInitialization(beanFactory);
                this.finishRefresh();
            }
            catch (BeansException ex) {
                this.applyState(ApplicationContext.State.FAILED);
                this.log.warn("Exception encountered during context initialization - cancelling refresh attempt: {}", (Object)ex.toString());
                this.destroyBeans();
                this.cancelRefresh((Exception)((Object)ex));
                throw ex;
            }
            finally {
                this.resetCommonCaches();
            }
        }
    }

    protected void prepareRefresh() {
        this.startupDate = System.currentTimeMillis();
        this.closed.set(false);
        this.active.set(true);
        this.applyState(ApplicationContext.State.STARTING);
        ApplicationContextHolder.register(this);
        this.log.info("Starting application context at '{}'", (Object)this.formatStartupDate());
        ConfigurableEnvironment environment = this.getEnvironment();
        this.initPropertySources();
        environment.validateRequiredProperties();
        if (this.earlyApplicationListeners == null) {
            this.earlyApplicationListeners = new LinkedHashSet(this.applicationListeners);
        } else {
            this.applicationListeners.clear();
            this.applicationListeners.addAll(this.earlyApplicationListeners);
        }
        this.earlyApplicationEvents = new LinkedHashSet<ApplicationEvent>();
        if (this.log.isDebugEnabled()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Refreshing {}", (Object)this);
            } else {
                this.log.debug("Refreshing {}", (Object)this.getDisplayName());
            }
        }
    }

    protected void initPropertySources() throws ApplicationContextException {
    }

    protected void registerFrameworkComponents(ConfigurableBeanFactory beanFactory) {
        this.log.debug("Registering framework components");
        BootstrapContext bootstrapContext = this.obtainBootstrapContext();
        beanFactory.registerSingleton((Object)this.getInjector());
        if (!beanFactory.containsLocalBean("cn.taketoday.context.loader.internalBootstrapContext")) {
            beanFactory.registerSingleton("cn.taketoday.context.loader.internalBootstrapContext", (Object)bootstrapContext);
        }
        if (!beanFactory.containsLocalBean("environment")) {
            beanFactory.registerSingleton("environment", (Object)this.getEnvironment());
        }
        if (!beanFactory.containsLocalBean("systemProperties")) {
            beanFactory.registerSingleton("systemProperties", (Object)this.getEnvironment().getSystemProperties());
        }
        if (!beanFactory.containsLocalBean("systemEnvironment")) {
            beanFactory.registerSingleton("systemEnvironment", (Object)this.getEnvironment().getSystemEnvironment());
        }
    }

    protected void onRefresh() {
    }

    protected ConfigurableBeanFactory obtainFreshBeanFactory() {
        this.refreshBeanFactory();
        return this.getBeanFactory();
    }

    public void prepareBeanFactory(ConfigurableBeanFactory beanFactory) {
        this.log.debug("Preparing bean-factory: {}", (Object)beanFactory);
        ClassLoader classLoader = this.getClassLoader();
        beanFactory.setBeanClassLoader(classLoader);
        beanFactory.setBeanExpressionResolver((BeanExpressionResolver)new StandardBeanExpressionResolver());
        beanFactory.addPropertyEditorRegistrar((PropertyEditorRegistrar)new ResourceEditorRegistrar((ResourceLoader)this, (PropertyResolver)this.getEnvironment()));
        beanFactory.addBeanPostProcessor((BeanPostProcessor)new ContextAwareProcessor(this, this.obtainBootstrapContext()));
        beanFactory.addBeanPostProcessor((BeanPostProcessor)new ApplicationListenerDetector(this));
        if (beanFactory.containsBean("loadTimeWeaver")) {
            beanFactory.addBeanPostProcessor((BeanPostProcessor)new LoadTimeWeaverAwareProcessor((BeanFactory)beanFactory));
            beanFactory.setTempClassLoader((ClassLoader)((Object)new ContextTypeMatchClassLoader(beanFactory.getBeanClassLoader())));
        }
        beanFactory.ignoreDependencyInterface(EnvironmentAware.class);
        beanFactory.ignoreDependencyInterface(EmbeddedValueResolverAware.class);
        beanFactory.ignoreDependencyInterface(ResourceLoaderAware.class);
        beanFactory.ignoreDependencyInterface(ApplicationEventPublisherAware.class);
        beanFactory.ignoreDependencyInterface(MessageSourceAware.class);
        beanFactory.ignoreDependencyInterface(BootstrapContextAware.class);
        beanFactory.ignoreDependencyInterface(ApplicationContextAware.class);
        beanFactory.registerDependency(BeanFactory.class, (Object)beanFactory);
        beanFactory.registerDependency(ResourceLoader.class, (Object)this);
        beanFactory.registerDependency(ApplicationEventPublisher.class, (Object)this);
        beanFactory.registerDependency(ApplicationContext.class, (Object)this);
        List strategies = TodayStrategies.find(BeanDefinitionLoader.class, (ClassLoader)classLoader, (TodayStrategies.Instantiator)BeanFactoryAwareInstantiator.from((BeanFactory)beanFactory));
        if (!strategies.isEmpty()) {
            BootstrapContext bootstrapContext = this.obtainBootstrapContext();
            for (BeanDefinitionLoader loader : strategies) {
                loader.loadBeanDefinitions(bootstrapContext);
            }
        }
    }

    protected void postProcessBeanFactory(ConfigurableBeanFactory beanFactory) {
    }

    protected void invokeBeanFactoryPostProcessors(ConfigurableBeanFactory beanFactory) {
        this.log.debug("Invoking bean-factory-post-processors");
        PostProcessorRegistrationDelegate.invokeBeanFactoryPostProcessors(beanFactory, this.factoryPostProcessors);
        if (beanFactory.getTempClassLoader() == null && beanFactory.containsBean("loadTimeWeaver")) {
            beanFactory.addBeanPostProcessor((BeanPostProcessor)new LoadTimeWeaverAwareProcessor((BeanFactory)beanFactory));
            beanFactory.setTempClassLoader((ClassLoader)((Object)new ContextTypeMatchClassLoader(beanFactory.getBeanClassLoader())));
        }
    }

    protected void registerBeanPostProcessors(ConfigurableBeanFactory beanFactory) {
        this.log.debug("Registering bean-post-processors");
        PostProcessorRegistrationDelegate.registerBeanPostProcessors(beanFactory, this);
    }

    protected void initMessageSource() {
        ConfigurableBeanFactory beanFactory = this.getBeanFactory();
        if (beanFactory.containsLocalBean(MESSAGE_SOURCE_BEAN_NAME)) {
            HierarchicalMessageSource hms;
            MessageSource messageSource;
            this.messageSource = (MessageSource)beanFactory.getBean(MESSAGE_SOURCE_BEAN_NAME, MessageSource.class);
            if (this.parent != null && (messageSource = this.messageSource) instanceof HierarchicalMessageSource && (hms = (HierarchicalMessageSource)messageSource).getParentMessageSource() == null) {
                hms.setParentMessageSource(this.getInternalParentMessageSource());
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("Using MessageSource [{}]", (Object)this.messageSource);
            }
        } else {
            DelegatingMessageSource dms = new DelegatingMessageSource();
            dms.setParentMessageSource(this.getInternalParentMessageSource());
            this.messageSource = dms;
            beanFactory.registerSingleton(MESSAGE_SOURCE_BEAN_NAME, (Object)this.messageSource);
            if (this.log.isTraceEnabled()) {
                this.log.trace("No '{}' bean, using [{}]", (Object)MESSAGE_SOURCE_BEAN_NAME, (Object)this.messageSource);
            }
        }
    }

    protected void cancelRefresh(Exception ex) {
        this.active.set(false);
    }

    protected void doClose() {
        if (this.active.get() && this.closed.compareAndSet(false, true)) {
            this.log.info("Closing: [{}] at [{}]", (Object)this, (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(System.currentTimeMillis()));
            try {
                this.publishEvent(new ContextClosedEvent(this));
            }
            catch (Throwable ex) {
                this.log.warn("Exception thrown from ApplicationListener handling ContextClosedEvent", ex);
            }
            if (this.lifecycleProcessor != null) {
                try {
                    this.lifecycleProcessor.onClose();
                }
                catch (Throwable ex) {
                    this.log.warn("Exception thrown from LifecycleProcessor on context close", ex);
                }
            }
            this.destroyBeans();
            this.closeBeanFactory();
            this.onClose();
            if (this.earlyApplicationListeners != null) {
                this.applicationListeners.clear();
                this.applicationListeners.addAll(this.earlyApplicationListeners);
            }
            this.active.set(false);
        }
    }

    @Override
    public void registerShutdownHook() {
        if (this.shutdownHook == null) {
            this.shutdownHook = new Thread("ContextShutdownHook"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = AbstractApplicationContext.this.startupShutdownMonitor;
                    synchronized (object) {
                        AbstractApplicationContext.this.doClose();
                    }
                }
            };
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.startupShutdownMonitor;
        synchronized (object) {
            this.applyState(ApplicationContext.State.CLOSING);
            this.doClose();
            if (this.shutdownHook != null) {
                try {
                    Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            this.applyState(ApplicationContext.State.CLOSED);
            ApplicationContextHolder.remove(this);
        }
    }

    protected void destroyBeans() {
        this.getBeanFactory().destroySingletons();
    }

    protected void onClose() {
    }

    @Override
    public boolean isActive() {
        return this.active.get();
    }

    @Override
    public <T> T unwrapFactory(Class<T> requiredType) {
        ConfigurableBeanFactory beanFactory = this.getBeanFactory();
        if (requiredType.isInstance(beanFactory)) {
            return (T)beanFactory;
        }
        throw new IllegalArgumentException("bean factory must be a " + requiredType);
    }

    @Override
    public boolean hasStarted() {
        return this.state == ApplicationContext.State.STARTED;
    }

    @Override
    public ApplicationContext.State getState() {
        return this.state;
    }

    protected void applyState(ApplicationContext.State state) {
        this.state = state;
    }

    @Override
    public long getStartupDate() {
        return this.startupDate;
    }

    @Override
    public void setParent(@Nullable ApplicationContext parent) {
        Environment parentEnvironment;
        this.parent = parent;
        if (parent != null && (parentEnvironment = parent.getEnvironment()) instanceof ConfigurableEnvironment) {
            this.getEnvironment().merge((ConfigurableEnvironment)parentEnvironment);
        }
    }

    @Override
    public ConfigurableEnvironment getEnvironment() {
        if (this.environment == null) {
            this.environment = this.createEnvironment();
        }
        return this.environment;
    }

    protected ConfigurableEnvironment createEnvironment() {
        return new StandardEnvironment();
    }

    @Override
    public void setEnvironment(ConfigurableEnvironment environment) {
        this.environment = environment;
    }

    @Override
    public void addBeanFactoryPostProcessor(BeanFactoryPostProcessor postProcessor) {
        Assert.notNull((Object)postProcessor, (String)"BeanFactoryPostProcessor must not be null");
        this.factoryPostProcessors.add(postProcessor);
    }

    protected void assertBeanFactoryActive() {
        if (!this.active.get()) {
            if (this.closed.get()) {
                throw new IllegalStateException(this.getDisplayName() + " has been closed already");
            }
            throw new IllegalStateException(this.getDisplayName() + " has not been refreshed yet");
        }
    }

    public Object getBean(String name) {
        this.assertBeanFactoryActive();
        return this.getBeanFactory().getBean(name);
    }

    public Object getBean(String name, Object ... args) throws BeansException {
        this.assertBeanFactoryActive();
        return this.getBeanFactory().getBean(name, args);
    }

    public <T> T getBean(Class<T> requiredType) {
        this.assertBeanFactoryActive();
        return (T)this.getBeanFactory().getBean(requiredType);
    }

    public <T> T getBean(Class<T> requiredType, Object ... args) throws BeansException {
        this.assertBeanFactoryActive();
        return (T)this.getBeanFactory().getBean(requiredType, args);
    }

    public <T> T getBean(String name, Class<T> requiredType) {
        this.assertBeanFactoryActive();
        return (T)this.getBeanFactory().getBean(name, requiredType);
    }

    public <A extends Annotation> A findSynthesizedAnnotation(String beanName, Class<A> annotationType) {
        this.assertBeanFactoryActive();
        return (A)this.getBeanFactory().findSynthesizedAnnotation(beanName, annotationType);
    }

    public <A extends Annotation> MergedAnnotation<A> findAnnotationOnBean(String beanName, Class<A> annotationType) throws NoSuchBeanDefinitionException {
        this.assertBeanFactoryActive();
        return this.getBeanFactory().findAnnotationOnBean(beanName, annotationType);
    }

    public <A extends Annotation> MergedAnnotation<A> findAnnotationOnBean(String beanName, Class<A> annotationType, boolean allowFactoryBeanInit) throws NoSuchBeanDefinitionException {
        this.assertBeanFactoryActive();
        return this.getBeanFactory().findAnnotationOnBean(beanName, annotationType, allowFactoryBeanInit);
    }

    public <T> List<T> getAnnotatedBeans(Class<? extends Annotation> annotationType) {
        this.assertBeanFactoryActive();
        return this.getBeanFactory().getAnnotatedBeans(annotationType);
    }

    public Map<String, Object> getBeansWithAnnotation(Class<? extends Annotation> annotationType) {
        this.assertBeanFactoryActive();
        return this.getBeanFactory().getBeansWithAnnotation(annotationType);
    }

    public Map<String, Object> getBeansWithAnnotation(Class<? extends Annotation> annotationType, boolean includeNonSingletons) {
        this.assertBeanFactoryActive();
        return this.getBeanFactory().getBeansWithAnnotation(annotationType, includeNonSingletons);
    }

    public Map<String, BeanDefinition> getBeanDefinitions() {
        return this.getBeanFactory().getBeanDefinitions();
    }

    public boolean isSingleton(String name) {
        this.assertBeanFactoryActive();
        return this.getBeanFactory().isSingleton(name);
    }

    public boolean isPrototype(String name) {
        this.assertBeanFactoryActive();
        return this.getBeanFactory().isPrototype(name);
    }

    public Class<?> getType(String name) {
        this.assertBeanFactoryActive();
        return this.getBeanFactory().getType(name);
    }

    @Nullable
    public Class<?> getType(String name, boolean allowFactoryBeanInit) throws NoSuchBeanDefinitionException {
        this.assertBeanFactoryActive();
        return this.getBeanFactory().getType(name, allowFactoryBeanInit);
    }

    public Set<String> getBeanNamesForAnnotation(Class<? extends Annotation> annotationType) {
        this.assertBeanFactoryActive();
        return this.getBeanFactory().getBeanNamesForAnnotation(annotationType);
    }

    public boolean containsBean(String name) {
        return this.getBeanFactory().containsBean(name);
    }

    public boolean isTypeMatch(String name, Class<?> typeToMatch) throws NoSuchBeanDefinitionException {
        this.assertBeanFactoryActive();
        return this.getBeanFactory().isTypeMatch(name, typeToMatch);
    }

    public boolean isTypeMatch(String name, ResolvableType typeToMatch) throws NoSuchBeanDefinitionException {
        this.assertBeanFactoryActive();
        return this.getBeanFactory().isTypeMatch(name, typeToMatch);
    }

    public <T> ObjectProvider<T> getBeanProvider(Class<T> requiredType) {
        this.assertBeanFactoryActive();
        return this.getBeanFactory().getBeanProvider(requiredType);
    }

    public <T> ObjectProvider<T> getBeanProvider(ResolvableType requiredType) {
        this.assertBeanFactoryActive();
        return this.getBeanFactory().getBeanProvider(requiredType);
    }

    public <T> ObjectProvider<T> getBeanProvider(Class<T> requiredType, boolean allowEagerInit) {
        this.assertBeanFactoryActive();
        return this.getBeanFactory().getBeanProvider(requiredType, allowEagerInit);
    }

    public <T> ObjectProvider<T> getBeanProvider(ResolvableType requiredType, boolean allowEagerInit) {
        this.assertBeanFactoryActive();
        return this.getBeanFactory().getBeanProvider(requiredType, allowEagerInit);
    }

    public String[] getAliases(String name) {
        this.assertBeanFactoryActive();
        return this.getBeanFactory().getAliases(name);
    }

    public <T> List<T> getBeans(Class<T> requiredType) {
        this.assertBeanFactoryActive();
        return this.getBeanFactory().getBeans(requiredType);
    }

    public Set<String> getBeanNamesForType(Class<?> requiredType, boolean includeNonSingletons) {
        this.assertBeanFactoryActive();
        return this.getBeanFactory().getBeanNamesForType(requiredType, includeNonSingletons);
    }

    public Set<String> getBeanNamesForType(Class<?> requiredType, boolean includeNonSingletons, boolean allowEagerInit) {
        this.assertBeanFactoryActive();
        return this.getBeanFactory().getBeanNamesForType(requiredType, includeNonSingletons, allowEagerInit);
    }

    public <T> Map<String, T> getBeansOfType(Class<T> requiredType) {
        this.assertBeanFactoryActive();
        return this.getBeanFactory().getBeansOfType(requiredType);
    }

    public <T> Map<String, T> getBeansOfType(Class<T> requiredType, boolean includeNonSingletons, boolean allowEagerInit) {
        this.assertBeanFactoryActive();
        return this.getBeanFactory().getBeansOfType(requiredType, includeNonSingletons, allowEagerInit);
    }

    public <T> Map<String, T> getBeansOfType(ResolvableType requiredType, boolean includeNonSingletons, boolean allowEagerInit) {
        this.assertBeanFactoryActive();
        return this.getBeanFactory().getBeansOfType(requiredType, includeNonSingletons, allowEagerInit);
    }

    public Set<String> getBeanNamesForType(ResolvableType requiredType) {
        this.assertBeanFactoryActive();
        return this.getBeanFactory().getBeanNamesForType(requiredType);
    }

    public Set<String> getBeanNamesForType(ResolvableType requiredType, boolean includeNonSingletons, boolean allowEagerInit) {
        this.assertBeanFactoryActive();
        return this.getBeanFactory().getBeanNamesForType(requiredType, includeNonSingletons, allowEagerInit);
    }

    public boolean containsBeanDefinition(String beanName) {
        this.assertBeanFactoryActive();
        return this.getBeanFactory().containsBeanDefinition(beanName);
    }

    public BeanDefinition getBeanDefinition(String beanName) throws BeansException {
        this.assertBeanFactoryActive();
        return this.getBeanFactory().getBeanDefinition(beanName);
    }

    public int getBeanDefinitionCount() {
        this.assertBeanFactoryActive();
        return this.getBeanFactory().getBeanDefinitionCount();
    }

    public String[] getBeanDefinitionNames() {
        this.assertBeanFactoryActive();
        return new String[0];
    }

    public DependencyInjector getInjector() {
        return this.getBeanFactory().getInjector();
    }

    public List<BeanFactoryPostProcessor> getFactoryPostProcessors() {
        return this.factoryPostProcessors;
    }

    public void addFactoryPostProcessors(BeanFactoryPostProcessor ... postProcessors) {
        CollectionUtils.addAll(this.factoryPostProcessors, (Object[])postProcessors);
    }

    @Override
    public void start() {
        this.getLifecycleProcessor().start();
        this.publishEvent(new ContextStartedEvent(this));
    }

    @Override
    public void stop() {
        this.getLifecycleProcessor().stop();
        this.publishEvent(new ContextStoppedEvent(this));
    }

    @Override
    public boolean isRunning() {
        return this.lifecycleProcessor != null && this.lifecycleProcessor.isRunning();
    }

    public void setLifecycleProcessor(@Nullable LifecycleProcessor lifecycleProcessor) {
        this.lifecycleProcessor = lifecycleProcessor;
    }

    protected void initLifecycleProcessor() {
        if (this.lifecycleProcessor == null) {
            ConfigurableBeanFactory beanFactory = this.getBeanFactory();
            if (beanFactory.containsLocalBean(LIFECYCLE_PROCESSOR_BEAN_NAME)) {
                this.lifecycleProcessor = (LifecycleProcessor)beanFactory.getBean(LIFECYCLE_PROCESSOR_BEAN_NAME, LifecycleProcessor.class);
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Using LifecycleProcessor [{}]", (Object)this.lifecycleProcessor);
                }
            } else {
                DefaultLifecycleProcessor defaultProcessor = new DefaultLifecycleProcessor();
                defaultProcessor.setBeanFactory((BeanFactory)beanFactory);
                this.lifecycleProcessor = defaultProcessor;
                beanFactory.registerSingleton(LIFECYCLE_PROCESSOR_BEAN_NAME, (Object)this.lifecycleProcessor);
                if (this.log.isTraceEnabled()) {
                    this.log.trace("No '{}' bean, using [{}]", (Object)LIFECYCLE_PROCESSOR_BEAN_NAME, (Object)this.lifecycleProcessor.getClass().getSimpleName());
                }
            }
        }
    }

    public LifecycleProcessor getLifecycleProcessor() throws IllegalStateException {
        if (this.lifecycleProcessor == null) {
            throw new IllegalStateException("LifecycleProcessor not initialized - call 'refresh' before invoking lifecycle methods via the context: " + this);
        }
        return this.lifecycleProcessor;
    }

    public ApplicationEventMulticaster getApplicationEventMulticaster() throws IllegalStateException {
        if (this.applicationEventMulticaster == null) {
            throw new IllegalStateException("ApplicationEventMulticaster not initialized - call 'refresh' before multicasting events via the context: " + this);
        }
        return this.applicationEventMulticaster;
    }

    protected void initApplicationEventMulticaster() {
        ConfigurableBeanFactory beanFactory = this.getBeanFactory();
        if (beanFactory.containsLocalBean(APPLICATION_EVENT_MULTICASTER_BEAN_NAME)) {
            this.applicationEventMulticaster = (ApplicationEventMulticaster)beanFactory.getBean(APPLICATION_EVENT_MULTICASTER_BEAN_NAME, ApplicationEventMulticaster.class);
            if (this.log.isTraceEnabled()) {
                this.log.trace("Using ApplicationEventMulticaster [{}]", (Object)this.applicationEventMulticaster);
            }
        } else {
            this.applicationEventMulticaster = new SimpleApplicationEventMulticaster((BeanFactory)beanFactory);
            beanFactory.registerSingleton(APPLICATION_EVENT_MULTICASTER_BEAN_NAME, (Object)this.applicationEventMulticaster);
            if (this.log.isTraceEnabled()) {
                this.log.trace("No '{}' bean, using [{}]", (Object)APPLICATION_EVENT_MULTICASTER_BEAN_NAME, (Object)this.applicationEventMulticaster.getClass().getSimpleName());
            }
        }
    }

    public Collection<ApplicationListener<?>> getApplicationListeners() {
        return this.applicationListeners;
    }

    @Override
    public void publishEvent(Object event) {
        this.publishEvent(event, null);
    }

    protected void publishEvent(Object event, @Nullable ResolvableType eventType) {
        PayloadApplicationEvent<Object> applicationEvent;
        Assert.notNull((Object)event, (String)"Event is required");
        if (event instanceof ApplicationEvent) {
            applicationEvent = (PayloadApplicationEvent<Object>)event;
        } else {
            applicationEvent = new PayloadApplicationEvent<Object>(this, event, eventType);
            if (eventType == null) {
                eventType = applicationEvent.getResolvableType();
            }
        }
        if (this.earlyApplicationEvents != null) {
            this.earlyApplicationEvents.add(applicationEvent);
        } else {
            this.getApplicationEventMulticaster().multicastEvent(applicationEvent, eventType);
        }
        if (this.parent != null) {
            ApplicationContext applicationContext = this.parent;
            if (applicationContext instanceof AbstractApplicationContext) {
                AbstractApplicationContext parentCtx = (AbstractApplicationContext)applicationContext;
                parentCtx.publishEvent(event, eventType);
            } else {
                this.parent.publishEvent(event);
            }
        }
    }

    protected void registerApplicationListeners() {
        this.log.debug("Registering application-listeners");
        ApplicationEventMulticaster eventMulticaster = this.getApplicationEventMulticaster();
        for (ApplicationListener<?> applicationListener : this.getApplicationListeners()) {
            eventMulticaster.addApplicationListener(applicationListener);
        }
        Set<String> listenerBeanNames = this.getBeanNamesForType(ApplicationListener.class, true, false);
        for (String listenerBeanName : listenerBeanNames) {
            eventMulticaster.addApplicationListenerBean(listenerBeanName);
        }
        this.log.debug("Publish early application events");
        Set<ApplicationEvent> set = this.earlyApplicationEvents;
        this.earlyApplicationEvents = null;
        if (CollectionUtils.isNotEmpty(set)) {
            for (ApplicationEvent earlyEvent : set) {
                eventMulticaster.multicastEvent(earlyEvent);
            }
        }
    }

    @Override
    public void addApplicationListener(ApplicationListener<?> listener) {
        Assert.notNull(listener, (String)"ApplicationListener is required");
        if (this.applicationEventMulticaster != null) {
            this.applicationEventMulticaster.addApplicationListener(listener);
        }
        this.applicationListeners.add(listener);
    }

    @Override
    public void removeApplicationListener(ApplicationListener<?> listener) {
        Assert.notNull(listener, (String)"ApplicationListener must not be null");
        if (this.applicationEventMulticaster != null) {
            this.applicationEventMulticaster.removeApplicationListener(listener);
        }
        this.applicationListeners.remove(listener);
    }

    protected void finishBeanFactoryInitialization(ConfigurableBeanFactory beanFactory) {
        if (beanFactory.containsBean("conversionService") && beanFactory.isTypeMatch("conversionService", ConversionService.class)) {
            beanFactory.setConversionService((ConversionService)beanFactory.getBean("conversionService", ConversionService.class));
        }
        if (!beanFactory.hasEmbeddedValueResolver()) {
            beanFactory.addEmbeddedValueResolver(strVal -> this.getEnvironment().resolveRequiredPlaceholders(strVal));
        }
        Set weaverAwareNames = beanFactory.getBeanNamesForType(LoadTimeWeaverAware.class, false, false);
        for (String weaverAwareName : weaverAwareNames) {
            this.getBean(weaverAwareName);
        }
        beanFactory.setTempClassLoader(null);
        beanFactory.freezeConfiguration();
        beanFactory.preInstantiateSingletons();
    }

    protected void finishRefresh() {
        this.clearResourceCaches();
        this.initLifecycleProcessor();
        this.getLifecycleProcessor().onRefresh();
        this.publishEvent(new ContextRefreshedEvent(this));
        this.applyState(ApplicationContext.State.STARTED);
        this.log.info("Application context startup in {}ms", (Object)(System.currentTimeMillis() - this.getStartupDate()));
    }

    protected abstract void refreshBeanFactory() throws BeansException, IllegalStateException;

    protected void closeBeanFactory() {
    }

    @Override
    public abstract ConfigurableBeanFactory getBeanFactory();

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getDisplayName());
        sb.append(": state: [").append((Object)this.state).append("], on startup date: ").append(this.formatStartupDate());
        ApplicationContext parent = this.getParent();
        if (parent != null) {
            sb.append(", parent: ").append(parent.getDisplayName());
        }
        return sb.toString();
    }

    public String formatStartupDate() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(this.startupDate);
    }
}

