/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.properties.source;

import cn.taketoday.context.properties.source.ConfigurationPropertySource;
import cn.taketoday.core.env.PropertySource;
import java.util.Set;
import java.util.function.Function;

public class UnboundElementsSourceFilter
implements Function<ConfigurationPropertySource, Boolean> {
    private static final Set<String> BENIGN_PROPERTY_SOURCE_NAMES = Set.of("systemEnvironment", "systemProperties");

    @Override
    public Boolean apply(ConfigurationPropertySource configurationPropertySource) {
        Object underlyingSource = configurationPropertySource.getUnderlyingSource();
        if (underlyingSource instanceof PropertySource) {
            String name = ((PropertySource)underlyingSource).getName();
            return !BENIGN_PROPERTY_SOURCE_NAMES.contains(name);
        }
        return true;
    }
}

