/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.properties.source;

import cn.taketoday.context.properties.source.ConfigurationPropertyCaching;
import cn.taketoday.lang.Nullable;
import java.lang.ref.SoftReference;
import java.time.Duration;
import java.time.Instant;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

class SoftReferenceConfigurationPropertyCache<T>
implements ConfigurationPropertyCaching {
    private static final Duration UNLIMITED = Duration.ZERO;
    private final boolean neverExpire;
    @Nullable
    private volatile Duration timeToLive;
    private volatile SoftReference<T> valueRef = new SoftReference<Object>(null);
    @Nullable
    private volatile Instant lastAccessed = this.now();

    SoftReferenceConfigurationPropertyCache(boolean neverExpire) {
        this.neverExpire = neverExpire;
    }

    @Override
    public void enable() {
        this.timeToLive = UNLIMITED;
    }

    @Override
    public void disable() {
        this.timeToLive = null;
    }

    @Override
    public void setTimeToLive(@Nullable Duration timeToLive) {
        this.timeToLive = timeToLive == null || timeToLive.isZero() ? null : timeToLive;
    }

    @Override
    public void clear() {
        this.lastAccessed = null;
    }

    T get(Supplier<T> factory, UnaryOperator<T> refreshAction) {
        Object value = this.getValue();
        if (value == null) {
            value = refreshAction.apply(factory.get());
            this.setValue(value);
        } else if (this.hasExpired()) {
            value = refreshAction.apply(value);
            this.setValue(value);
        }
        if (!this.neverExpire) {
            this.lastAccessed = this.now();
        }
        return value;
    }

    private boolean hasExpired() {
        if (this.neverExpire) {
            return false;
        }
        Duration timeToLive = this.timeToLive;
        Instant lastAccessed = this.lastAccessed;
        if (timeToLive == null || lastAccessed == null) {
            return true;
        }
        return !UNLIMITED.equals(timeToLive) && this.now().isAfter(lastAccessed.plus(timeToLive));
    }

    protected Instant now() {
        return Instant.now();
    }

    @Nullable
    protected T getValue() {
        return this.valueRef.get();
    }

    protected void setValue(T value) {
        this.valueRef = new SoftReference<T>(value);
    }
}

