/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.properties.source;

import cn.taketoday.context.properties.source.ConfigurationPropertyName;
import cn.taketoday.context.properties.source.IterableConfigurationPropertySource;
import cn.taketoday.context.properties.source.PrefixedConfigurationPropertySource;
import java.util.stream.Stream;

class PrefixedIterableConfigurationPropertySource
extends PrefixedConfigurationPropertySource
implements IterableConfigurationPropertySource {
    PrefixedIterableConfigurationPropertySource(IterableConfigurationPropertySource source, String prefix) {
        super(source, prefix);
    }

    @Override
    public Stream<ConfigurationPropertyName> stream() {
        return this.getSource().stream().map(this::stripPrefix);
    }

    private ConfigurationPropertyName stripPrefix(ConfigurationPropertyName name) {
        return this.getPrefix().isAncestorOf(name) ? name.subName(this.getPrefix().getNumberOfElements()) : name;
    }

    @Override
    protected IterableConfigurationPropertySource getSource() {
        return (IterableConfigurationPropertySource)super.getSource();
    }
}

