/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.properties.source;

import cn.taketoday.context.properties.source.AliasedIterableConfigurationPropertySource;
import cn.taketoday.context.properties.source.ConfigurationPropertyName;
import cn.taketoday.context.properties.source.ConfigurationPropertyNameAliases;
import cn.taketoday.context.properties.source.ConfigurationPropertySource;
import cn.taketoday.context.properties.source.ConfigurationPropertyState;
import cn.taketoday.context.properties.source.FilteredIterableConfigurationPropertiesSource;
import cn.taketoday.context.properties.source.PrefixedIterableConfigurationPropertySource;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.StringUtils;
import java.util.Iterator;
import java.util.function.Predicate;
import java.util.stream.Stream;

public interface IterableConfigurationPropertySource
extends ConfigurationPropertySource,
Iterable<ConfigurationPropertyName> {
    @Override
    default public Iterator<ConfigurationPropertyName> iterator() {
        return this.stream().iterator();
    }

    public Stream<ConfigurationPropertyName> stream();

    @Override
    default public ConfigurationPropertyState containsDescendantOf(ConfigurationPropertyName name) {
        return ConfigurationPropertyState.search(this, name::isAncestorOf);
    }

    @Override
    default public IterableConfigurationPropertySource filter(Predicate<ConfigurationPropertyName> filter) {
        return new FilteredIterableConfigurationPropertiesSource(this, filter);
    }

    @Override
    default public IterableConfigurationPropertySource withAliases(ConfigurationPropertyNameAliases aliases) {
        return new AliasedIterableConfigurationPropertySource(this, aliases);
    }

    @Override
    default public IterableConfigurationPropertySource withPrefix(@Nullable String prefix) {
        return StringUtils.hasText((String)prefix) ? new PrefixedIterableConfigurationPropertySource(this, prefix) : this;
    }
}

