/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.properties.source;

import cn.taketoday.context.properties.source.ConfigurationPropertySource;
import cn.taketoday.context.properties.source.ConfigurationPropertySourcesPropertySource;
import cn.taketoday.context.properties.source.DefaultConfigurationPropertySource;
import cn.taketoday.core.env.ConfigurableEnvironment;
import cn.taketoday.core.env.PropertySource;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.origin.OriginLookup;
import cn.taketoday.util.ConcurrentReferenceHashMap;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;

class DefaultConfigurationPropertySources
implements Iterable<ConfigurationPropertySource> {
    private final Iterable<PropertySource<?>> sources;
    private final ConcurrentReferenceHashMap<PropertySource<?>, ConfigurationPropertySource> cache = new ConcurrentReferenceHashMap(16, ConcurrentReferenceHashMap.ReferenceType.SOFT);

    DefaultConfigurationPropertySources(Iterable<PropertySource<?>> sources) {
        Assert.notNull(sources, (String)"Sources is required");
        this.sources = sources;
    }

    boolean isUsingSources(Iterable<PropertySource<?>> sources) {
        return this.sources == sources;
    }

    @Override
    public Iterator<ConfigurationPropertySource> iterator() {
        return new SourcesIterator(this.sources.iterator(), this::adapt);
    }

    private ConfigurationPropertySource adapt(PropertySource<?> source) {
        ConfigurationPropertySource result = (ConfigurationPropertySource)this.cache.get(source);
        if (result != null && result.getUnderlyingSource() == source) {
            return result;
        }
        result = DefaultConfigurationPropertySource.from(source);
        if (source instanceof OriginLookup) {
            result = result.withPrefix(((OriginLookup)source).getPrefix());
        }
        this.cache.put(source, (Object)result);
        return result;
    }

    private static class SourcesIterator
    implements Iterator<ConfigurationPropertySource> {
        private final ArrayDeque<Iterator<PropertySource<?>>> iterators = new ArrayDeque(4);
        private final Function<PropertySource<?>, ConfigurationPropertySource> adapter;
        @Nullable
        private ConfigurationPropertySource next;

        SourcesIterator(Iterator<PropertySource<?>> iterator, Function<PropertySource<?>, ConfigurationPropertySource> adapter) {
            this.iterators.push(iterator);
            this.adapter = adapter;
        }

        @Override
        public boolean hasNext() {
            return this.fetchNext() != null;
        }

        @Override
        public ConfigurationPropertySource next() {
            ConfigurationPropertySource next = this.fetchNext();
            if (next == null) {
                throw new NoSuchElementException();
            }
            this.next = null;
            return next;
        }

        @Nullable
        private ConfigurationPropertySource fetchNext() {
            if (this.next == null) {
                if (this.iterators.isEmpty()) {
                    return null;
                }
                if (!this.iterators.peek().hasNext()) {
                    this.iterators.pop();
                    return this.fetchNext();
                }
                PropertySource<?> candidate = this.iterators.peek().next();
                if (candidate.getSource() instanceof ConfigurableEnvironment) {
                    this.push((ConfigurableEnvironment)candidate.getSource());
                    return this.fetchNext();
                }
                if (this.isIgnored(candidate)) {
                    return this.fetchNext();
                }
                this.next = this.adapter.apply(candidate);
            }
            return this.next;
        }

        private void push(ConfigurableEnvironment environment) {
            this.iterators.push(environment.getPropertySources().iterator());
        }

        private boolean isIgnored(PropertySource<?> candidate) {
            return candidate instanceof PropertySource.StubPropertySource || candidate instanceof ConfigurationPropertySourcesPropertySource;
        }
    }
}

