/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.properties.source;

import cn.taketoday.context.properties.source.ConfigurationProperty;
import cn.taketoday.context.properties.source.ConfigurationPropertyName;
import cn.taketoday.context.properties.source.ConfigurationPropertySource;
import cn.taketoday.core.env.PropertySource;
import cn.taketoday.lang.Nullable;
import cn.taketoday.origin.Origin;
import cn.taketoday.origin.OriginLookup;

class ConfigurationPropertySourcesPropertySource
extends PropertySource<Iterable<ConfigurationPropertySource>>
implements OriginLookup<String> {
    ConfigurationPropertySourcesPropertySource(String name, Iterable<ConfigurationPropertySource> source) {
        super(name, source);
    }

    public boolean containsProperty(String name) {
        return this.findConfigurationProperty(name) != null;
    }

    public Object getProperty(String name) {
        ConfigurationProperty configurationProperty = this.findConfigurationProperty(name);
        return configurationProperty != null ? configurationProperty.getValue() : null;
    }

    @Override
    public Origin getOrigin(String name) {
        return Origin.from(this.findConfigurationProperty(name));
    }

    @Nullable
    private ConfigurationProperty findConfigurationProperty(String name) {
        try {
            return this.findConfigurationProperty(ConfigurationPropertyName.of(name, true));
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Nullable
    ConfigurationProperty findConfigurationProperty(@Nullable ConfigurationPropertyName name) {
        if (name == null) {
            return null;
        }
        for (ConfigurationPropertySource configurationPropertySource : (Iterable)this.getSource()) {
            ConfigurationProperty configurationProperty = configurationPropertySource.getConfigurationProperty(name);
            if (configurationProperty == null) continue;
            return configurationProperty;
        }
        return null;
    }
}

