/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.properties.source;

import cn.taketoday.context.properties.source.ConfigurationProperty;
import cn.taketoday.context.properties.source.ConfigurationPropertyName;
import cn.taketoday.context.properties.source.ConfigurationPropertySources;
import cn.taketoday.context.properties.source.ConfigurationPropertySourcesPropertySource;
import cn.taketoday.context.properties.source.DefaultConfigurationPropertySources;
import cn.taketoday.core.env.AbstractPropertyResolver;
import cn.taketoday.core.env.PropertySource;
import cn.taketoday.core.env.PropertySources;
import cn.taketoday.core.env.PropertySourcesPropertyResolver;
import cn.taketoday.lang.Nullable;

class ConfigurationPropertySourcesPropertyResolver
extends AbstractPropertyResolver {
    private final PropertySources propertySources;
    private final DefaultResolver defaultResolver;

    ConfigurationPropertySourcesPropertyResolver(PropertySources propertySources) {
        this.propertySources = propertySources;
        this.defaultResolver = new DefaultResolver(propertySources);
    }

    public boolean containsProperty(String key) {
        ConfigurationPropertyName name;
        ConfigurationPropertySourcesPropertySource attached = this.getAttached();
        if (attached != null && (name = ConfigurationPropertyName.of(key, true)) != null) {
            try {
                return attached.findConfigurationProperty(name) != null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.defaultResolver.containsProperty(key);
    }

    public String getProperty(String key) {
        return this.getProperty(key, String.class, true);
    }

    public <T> T getProperty(String key, Class<T> targetValueType) {
        return this.getProperty(key, targetValueType, true);
    }

    protected String getPropertyAsRawString(String key) {
        return this.getProperty(key, String.class, false);
    }

    @Nullable
    private <T> T getProperty(String key, Class<T> targetValueType, boolean resolveNestedPlaceholders) {
        Object value = this.findPropertyValue(key);
        if (value == null) {
            return null;
        }
        if (resolveNestedPlaceholders && value instanceof String) {
            value = this.resolveNestedPlaceholders((String)value);
        }
        return (T)this.convertValueIfNecessary(value, targetValueType);
    }

    @Nullable
    private Object findPropertyValue(String key) {
        ConfigurationPropertyName name;
        ConfigurationPropertySourcesPropertySource attached = this.getAttached();
        if (attached != null && (name = ConfigurationPropertyName.of(key, true)) != null) {
            try {
                ConfigurationProperty configurationProperty = attached.findConfigurationProperty(name);
                return configurationProperty != null ? configurationProperty.getValue() : null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.defaultResolver.getProperty(key, Object.class, false);
    }

    @Nullable
    private ConfigurationPropertySourcesPropertySource getAttached() {
        DefaultConfigurationPropertySources cps;
        Object attachedSource;
        PropertySource<?> attached = ConfigurationPropertySources.getAttached(this.propertySources);
        Object object = attachedSource = attached != null ? attached.getSource() : null;
        if (attachedSource instanceof DefaultConfigurationPropertySources && (cps = (DefaultConfigurationPropertySources)attachedSource).isUsingSources((Iterable<PropertySource<?>>)this.propertySources)) {
            return (ConfigurationPropertySourcesPropertySource)attached;
        }
        return null;
    }

    static class DefaultResolver
    extends PropertySourcesPropertyResolver {
        DefaultResolver(PropertySources propertySources) {
            super(propertySources);
        }

        public <T> T getProperty(String key, Class<T> targetValueType, boolean resolveNestedPlaceholders) {
            return (T)super.getProperty(key, targetValueType, resolveNestedPlaceholders);
        }
    }
}

