/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.properties.source;

import cn.taketoday.context.properties.source.CachingConfigurationPropertySource;
import cn.taketoday.context.properties.source.ConfigurationPropertyCaching;
import cn.taketoday.context.properties.source.ConfigurationPropertySource;
import cn.taketoday.lang.Nullable;
import java.time.Duration;
import java.util.function.Consumer;

class ConfigurationPropertySourcesCaching
implements ConfigurationPropertyCaching {
    @Nullable
    private final Iterable<ConfigurationPropertySource> sources;

    ConfigurationPropertySourcesCaching(@Nullable Iterable<ConfigurationPropertySource> sources) {
        this.sources = sources;
    }

    @Override
    public void enable() {
        this.forEach(ConfigurationPropertyCaching::enable);
    }

    @Override
    public void disable() {
        this.forEach(ConfigurationPropertyCaching::disable);
    }

    @Override
    public void setTimeToLive(Duration timeToLive) {
        this.forEach(caching -> caching.setTimeToLive(timeToLive));
    }

    @Override
    public void clear() {
        this.forEach(ConfigurationPropertyCaching::clear);
    }

    private void forEach(Consumer<ConfigurationPropertyCaching> action) {
        if (this.sources != null) {
            for (ConfigurationPropertySource source : this.sources) {
                ConfigurationPropertyCaching caching = CachingConfigurationPropertySource.find(source);
                if (caching == null) continue;
                action.accept(caching);
            }
        }
    }
}

