/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.properties.source;

import cn.taketoday.context.properties.source.ConfigurationPropertySource;
import cn.taketoday.context.properties.source.ConfigurationPropertySourcesPropertyResolver;
import cn.taketoday.context.properties.source.ConfigurationPropertySourcesPropertySource;
import cn.taketoday.context.properties.source.DefaultConfigurationPropertySources;
import cn.taketoday.core.env.ConfigurableEnvironment;
import cn.taketoday.core.env.ConfigurablePropertyResolver;
import cn.taketoday.core.env.Environment;
import cn.taketoday.core.env.PropertySource;
import cn.taketoday.core.env.PropertySources;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import java.util.Collections;
import java.util.stream.Stream;

public final class ConfigurationPropertySources {
    private static final String ATTACHED_PROPERTY_SOURCE_NAME = "configurationProperties";

    private ConfigurationPropertySources() {
    }

    public static ConfigurablePropertyResolver createPropertyResolver(PropertySources propertySources) {
        return new ConfigurationPropertySourcesPropertyResolver(propertySources);
    }

    public static boolean isAttachedConfigurationPropertySource(PropertySource<?> propertySource) {
        return ATTACHED_PROPERTY_SOURCE_NAME.equals(propertySource.getName());
    }

    public static void attach(Environment environment) {
        Assert.isInstanceOf(ConfigurableEnvironment.class, (Object)environment);
        PropertySources sources = ((ConfigurableEnvironment)environment).getPropertySources();
        ConfigurationPropertySourcesPropertySource attached = ConfigurationPropertySources.getAttached(sources);
        if (attached == null || !ConfigurationPropertySources.isUsingSources(attached, sources)) {
            attached = new ConfigurationPropertySourcesPropertySource(ATTACHED_PROPERTY_SOURCE_NAME, new DefaultConfigurationPropertySources((Iterable<PropertySource<?>>)sources));
        }
        sources.remove(ATTACHED_PROPERTY_SOURCE_NAME);
        sources.addFirst((PropertySource)attached);
    }

    private static boolean isUsingSources(PropertySource<?> attached, PropertySources sources) {
        return attached instanceof ConfigurationPropertySourcesPropertySource && ((DefaultConfigurationPropertySources)attached.getSource()).isUsingSources((Iterable<PropertySource<?>>)sources);
    }

    @Nullable
    static PropertySource<?> getAttached(@Nullable PropertySources sources) {
        return sources != null ? sources.get(ATTACHED_PROPERTY_SOURCE_NAME) : null;
    }

    public static Iterable<ConfigurationPropertySource> get(Environment environment) {
        Assert.isInstanceOf(ConfigurableEnvironment.class, (Object)environment);
        PropertySources sources = ((ConfigurableEnvironment)environment).getPropertySources();
        ConfigurationPropertySourcesPropertySource attached = (ConfigurationPropertySourcesPropertySource)sources.get(ATTACHED_PROPERTY_SOURCE_NAME);
        if (attached == null) {
            return ConfigurationPropertySources.from(sources);
        }
        return (Iterable)attached.getSource();
    }

    public static Iterable<ConfigurationPropertySource> from(PropertySource<?> source) {
        return Collections.singleton(ConfigurationPropertySource.from(source));
    }

    public static Iterable<ConfigurationPropertySource> from(Iterable<PropertySource<?>> sources) {
        return new DefaultConfigurationPropertySources(sources);
    }

    private static Stream<PropertySource<?>> streamPropertySources(PropertySources sources) {
        return sources.stream().flatMap(ConfigurationPropertySources::flatten).filter(ConfigurationPropertySources::isIncluded);
    }

    private static Stream<PropertySource<?>> flatten(PropertySource<?> source) {
        if (source.getSource() instanceof ConfigurableEnvironment) {
            return ConfigurationPropertySources.streamPropertySources(((ConfigurableEnvironment)source.getSource()).getPropertySources());
        }
        return Stream.of(source);
    }

    private static boolean isIncluded(PropertySource<?> source) {
        return !(source instanceof PropertySource.StubPropertySource) && !(source instanceof ConfigurationPropertySourcesPropertySource);
    }
}

