/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.properties.source;

import cn.taketoday.context.properties.source.AliasedConfigurationPropertySource;
import cn.taketoday.context.properties.source.ConfigurationProperty;
import cn.taketoday.context.properties.source.ConfigurationPropertyName;
import cn.taketoday.context.properties.source.ConfigurationPropertyNameAliases;
import cn.taketoday.context.properties.source.ConfigurationPropertySourcesPropertySource;
import cn.taketoday.context.properties.source.ConfigurationPropertyState;
import cn.taketoday.context.properties.source.DefaultConfigurationPropertySource;
import cn.taketoday.context.properties.source.FilteredConfigurationPropertiesSource;
import cn.taketoday.context.properties.source.PrefixedConfigurationPropertySource;
import cn.taketoday.core.env.PropertySource;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.StringUtils;
import java.util.function.Predicate;

@FunctionalInterface
public interface ConfigurationPropertySource {
    @Nullable
    public ConfigurationProperty getConfigurationProperty(ConfigurationPropertyName var1);

    default public ConfigurationPropertyState containsDescendantOf(ConfigurationPropertyName name) {
        return ConfigurationPropertyState.UNKNOWN;
    }

    default public ConfigurationPropertySource filter(Predicate<ConfigurationPropertyName> filter) {
        return new FilteredConfigurationPropertiesSource(this, filter);
    }

    default public ConfigurationPropertySource withAliases(ConfigurationPropertyNameAliases aliases) {
        return new AliasedConfigurationPropertySource(this, aliases);
    }

    default public ConfigurationPropertySource withPrefix(@Nullable String prefix) {
        return StringUtils.hasText((String)prefix) ? new PrefixedConfigurationPropertySource(this, prefix) : this;
    }

    @Nullable
    default public Object getUnderlyingSource() {
        return null;
    }

    @Nullable
    public static ConfigurationPropertySource from(PropertySource<?> source) {
        if (source instanceof ConfigurationPropertySourcesPropertySource) {
            return null;
        }
        return DefaultConfigurationPropertySource.from(source);
    }
}

