/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.properties.source;

import cn.taketoday.context.properties.source.ConfigurationPropertyName;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.MultiValueMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class ConfigurationPropertyNameAliases
implements Iterable<ConfigurationPropertyName> {
    private final MultiValueMap<ConfigurationPropertyName, ConfigurationPropertyName> aliases = MultiValueMap.fromLinkedHashMap();

    public ConfigurationPropertyNameAliases() {
    }

    public ConfigurationPropertyNameAliases(String name, String ... aliases) {
        this.addAliases(name, aliases);
    }

    public ConfigurationPropertyNameAliases(ConfigurationPropertyName name, ConfigurationPropertyName ... aliases) {
        this.addAliases(name, aliases);
    }

    public void addAliases(String name, String ... aliases) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        Assert.notNull((Object)aliases, (String)"Aliases must not be null");
        this.addAliases(ConfigurationPropertyName.of(name), (ConfigurationPropertyName[])Arrays.stream(aliases).map(ConfigurationPropertyName::of).toArray(ConfigurationPropertyName[]::new));
    }

    public void addAliases(ConfigurationPropertyName name, ConfigurationPropertyName ... aliases) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        Assert.notNull((Object)aliases, (String)"Aliases must not be null");
        this.aliases.addAll((Object)name, Arrays.asList(aliases));
    }

    public List<ConfigurationPropertyName> getAliases(ConfigurationPropertyName name) {
        return (List)this.aliases.getOrDefault((Object)name, Collections.emptyList());
    }

    @Nullable
    public ConfigurationPropertyName getNameForAlias(ConfigurationPropertyName alias) {
        return this.aliases.entrySet().stream().filter(e -> ((List)e.getValue()).contains(alias)).map(Map.Entry::getKey).findFirst().orElse(null);
    }

    @Override
    public Iterator<ConfigurationPropertyName> iterator() {
        return this.aliases.keySet().iterator();
    }
}

