/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.properties.source;

import cn.taketoday.context.properties.source.CachingConfigurationPropertySource;
import cn.taketoday.context.properties.source.ConfigurationPropertySource;
import cn.taketoday.context.properties.source.ConfigurationPropertySources;
import cn.taketoday.context.properties.source.ConfigurationPropertySourcesCaching;
import cn.taketoday.core.env.Environment;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import java.time.Duration;

public interface ConfigurationPropertyCaching {
    public void enable();

    public void disable();

    public void setTimeToLive(Duration var1);

    public void clear();

    public static ConfigurationPropertyCaching get(Environment environment) {
        return ConfigurationPropertyCaching.get(environment, null);
    }

    public static ConfigurationPropertyCaching get(Environment environment, @Nullable Object underlyingSource) {
        Iterable<ConfigurationPropertySource> sources = ConfigurationPropertySources.get(environment);
        return ConfigurationPropertyCaching.get(sources, underlyingSource);
    }

    public static ConfigurationPropertyCaching get(Iterable<ConfigurationPropertySource> sources) {
        return ConfigurationPropertyCaching.get(sources, null);
    }

    public static ConfigurationPropertyCaching get(Iterable<ConfigurationPropertySource> sources, @Nullable Object underlyingSource) {
        Assert.notNull(sources, (String)"Sources must not be null");
        if (underlyingSource == null) {
            return new ConfigurationPropertySourcesCaching(sources);
        }
        for (ConfigurationPropertySource source : sources) {
            ConfigurationPropertyCaching caching;
            if (source.getUnderlyingSource() != underlyingSource || (caching = CachingConfigurationPropertySource.find(source)) == null) continue;
            return caching;
        }
        throw new IllegalStateException("Unable to find cache from configuration property sources");
    }
}

