/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.properties.source;

import cn.taketoday.context.properties.source.ConfigurationPropertyName;
import cn.taketoday.context.properties.source.ConfigurationPropertySource;
import cn.taketoday.core.style.ToStringBuilder;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.origin.Origin;
import cn.taketoday.origin.OriginProvider;
import cn.taketoday.util.ObjectUtils;

public final class ConfigurationProperty
implements OriginProvider,
Comparable<ConfigurationProperty> {
    private final ConfigurationPropertyName name;
    private final Object value;
    @Nullable
    private final ConfigurationPropertySource source;
    @Nullable
    private final Origin origin;

    public ConfigurationProperty(ConfigurationPropertyName name, Object value, @Nullable Origin origin) {
        this(null, name, value, origin);
    }

    private ConfigurationProperty(@Nullable ConfigurationPropertySource source, ConfigurationPropertyName name, Object value, @Nullable Origin origin) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        this.source = source;
        this.name = name;
        this.value = value;
        this.origin = origin;
    }

    @Nullable
    public ConfigurationPropertySource getSource() {
        return this.source;
    }

    public ConfigurationPropertyName getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    @Nullable
    public Origin getOrigin() {
        return this.origin;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigurationProperty other = (ConfigurationProperty)obj;
        boolean result = ObjectUtils.nullSafeEquals((Object)this.name, (Object)other.name);
        result = result && ObjectUtils.nullSafeEquals((Object)this.value, (Object)other.value);
        return result;
    }

    public int hashCode() {
        int result = ObjectUtils.nullSafeHashCode((Object)this.name);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.value);
        return result;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.name).append("value", this.value).append("origin", (Object)this.origin).toString();
    }

    @Override
    public int compareTo(ConfigurationProperty other) {
        return this.name.compareTo(other.name);
    }

    @Nullable
    static ConfigurationProperty of(@Nullable ConfigurationPropertySource source, ConfigurationPropertyName name, @Nullable Object value, @Nullable Origin origin) {
        if (value == null) {
            return null;
        }
        return new ConfigurationProperty(source, name, value, origin);
    }
}

