/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.properties.bind;

import cn.taketoday.beans.BeanUtils;
import cn.taketoday.context.properties.bind.BindConstructorProvider;
import cn.taketoday.context.properties.bind.BindConverter;
import cn.taketoday.context.properties.bind.Bindable;
import cn.taketoday.context.properties.bind.Binder;
import cn.taketoday.context.properties.bind.DataObjectBinder;
import cn.taketoday.context.properties.bind.DataObjectPropertyBinder;
import cn.taketoday.context.properties.bind.DataObjectPropertyName;
import cn.taketoday.context.properties.bind.DefaultValue;
import cn.taketoday.context.properties.bind.Name;
import cn.taketoday.context.properties.source.ConfigurationPropertyName;
import cn.taketoday.core.DefaultParameterNameDiscoverer;
import cn.taketoday.core.MethodParameter;
import cn.taketoday.core.ParameterNameDiscoverer;
import cn.taketoday.core.ResolvableType;
import cn.taketoday.core.annotation.MergedAnnotations;
import cn.taketoday.core.conversion.ConversionException;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.CollectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

class ValueObjectBinder
implements DataObjectBinder {
    private final BindConstructorProvider constructorProvider;

    ValueObjectBinder(BindConstructorProvider constructorProvider) {
        this.constructorProvider = constructorProvider;
    }

    @Override
    public <T> T bind(ConfigurationPropertyName name, Bindable<T> target, Binder.Context context, DataObjectPropertyBinder propertyBinder) {
        ValueObject<T> valueObject = ValueObject.get(target, this.constructorProvider, context);
        if (valueObject == null) {
            return null;
        }
        context.pushConstructorBoundTypes(target.getType().resolve());
        List<ConstructorParameter> parameters = valueObject.getConstructorParameters();
        ArrayList<Object> args = new ArrayList<Object>(parameters.size());
        boolean bound = false;
        for (ConstructorParameter parameter : parameters) {
            Object arg = parameter.bind(propertyBinder);
            bound = bound || arg != null;
            arg = arg != null ? arg : this.getDefaultValue(context, parameter);
            args.add(arg);
        }
        context.clearConfigurationProperty();
        context.popConstructorBoundTypes();
        return bound ? (T)valueObject.instantiate(args) : null;
    }

    @Override
    public <T> T create(Bindable<T> target, Binder.Context context) {
        ValueObject<T> valueObject = ValueObject.get(target, this.constructorProvider, context);
        if (valueObject == null) {
            return null;
        }
        List<ConstructorParameter> parameters = valueObject.getConstructorParameters();
        ArrayList<Object> args = new ArrayList<Object>(parameters.size());
        for (ConstructorParameter parameter : parameters) {
            args.add(this.getDefaultValue(context, parameter));
        }
        return valueObject.instantiate(args);
    }

    @Nullable
    private <T> T getDefaultValue(Binder.Context context, ConstructorParameter parameter) {
        Annotation[] annotations;
        ResolvableType type = parameter.type;
        for (Annotation annotation : annotations = parameter.annotations) {
            if (!(annotation instanceof DefaultValue)) continue;
            DefaultValue defaultValueAnnotation = (DefaultValue)annotation;
            String[] defaultValue = defaultValueAnnotation.value();
            if (defaultValue.length == 0) {
                return this.getNewDefaultValueInstanceIfPossible(context, type);
            }
            return this.convertDefaultValue(context.getConverter(), defaultValue, type, annotations);
        }
        return null;
    }

    @Nullable
    private <T> T convertDefaultValue(BindConverter converter, String[] defaultValue, ResolvableType type, Annotation[] annotations) {
        try {
            return converter.convert((Object)defaultValue, type, annotations);
        }
        catch (ConversionException ex) {
            if (defaultValue.length == 1) {
                return converter.convert((Object)defaultValue[0], type, annotations);
            }
            throw ex;
        }
    }

    @Nullable
    private <T> T getNewDefaultValueInstanceIfPossible(Binder.Context context, ResolvableType type) {
        Object instance;
        Class resolved = type.resolve();
        Assert.state((resolved == null || this.isEmptyDefaultValueAllowed(resolved) ? 1 : 0) != 0, () -> "Parameter of type " + type + " must have a non-empty default value.");
        if (resolved != null) {
            if (Optional.class == resolved) {
                return (T)Optional.empty();
            }
            if (Collection.class.isAssignableFrom(resolved)) {
                return (T)CollectionUtils.createCollection((Class)resolved, (int)0);
            }
            if (Map.class.isAssignableFrom(resolved)) {
                return (T)CollectionUtils.createMap((Class)resolved, (int)0);
            }
            if (resolved.isArray()) {
                return (T)Array.newInstance(resolved.getComponentType(), 0);
            }
        }
        if ((instance = this.create(Bindable.of(type), context)) != null) {
            return instance;
        }
        return (T)(resolved != null ? BeanUtils.newInstance((Class)resolved) : null);
    }

    private boolean isEmptyDefaultValueAllowed(Class<?> type) {
        return Optional.class == type || this.isAggregate(type) || !type.isPrimitive() && !type.isEnum() && !type.getName().startsWith("java.lang");
    }

    private boolean isAggregate(Class<?> type) {
        return type.isArray() || Map.class.isAssignableFrom(type) || Collection.class.isAssignableFrom(type);
    }

    private static abstract class ValueObject<T> {
        private final Constructor<T> constructor;

        protected ValueObject(Constructor<T> constructor) {
            this.constructor = constructor;
        }

        T instantiate(List<Object> args) {
            return (T)BeanUtils.newInstance(this.constructor, (Object[])args.toArray());
        }

        abstract List<ConstructorParameter> getConstructorParameters();

        @Nullable
        static <T> ValueObject<T> get(Bindable<T> bindable, BindConstructorProvider constructorProvider, Binder.Context context) {
            Class type = bindable.getType().resolve();
            if (type == null || type.isEnum() || Modifier.isAbstract(type.getModifiers())) {
                return null;
            }
            Constructor<?> bindConstructor = constructorProvider.getBindConstructor(bindable, context.isNestedConstructorBinding());
            if (bindConstructor == null) {
                return null;
            }
            return DefaultValueObject.get(bindConstructor, bindable.getType());
        }
    }

    private static class ConstructorParameter {
        public final String name;
        public final ResolvableType type;
        public final Annotation[] annotations;

        ConstructorParameter(String name, ResolvableType type, Annotation[] annotations) {
            this.name = DataObjectPropertyName.toDashedForm(name);
            this.type = type;
            this.annotations = annotations;
        }

        @Nullable
        Object bind(DataObjectPropertyBinder propertyBinder) {
            return propertyBinder.bindProperty(this.name, Bindable.of(this.type).withAnnotations(this.annotations));
        }
    }

    private static final class DefaultValueObject<T>
    extends ValueObject<T> {
        private static final ParameterNameDiscoverer PARAMETER_NAME_DISCOVERER = new DefaultParameterNameDiscoverer();
        private final List<ConstructorParameter> constructorParameters;

        private DefaultValueObject(Constructor<T> constructor, ResolvableType type) {
            super(constructor);
            this.constructorParameters = DefaultValueObject.parseConstructorParameters(constructor, type);
        }

        private static List<ConstructorParameter> parseConstructorParameters(Constructor<?> constructor, ResolvableType type) {
            String[] names = PARAMETER_NAME_DISCOVERER.getParameterNames(constructor);
            if (names == null) {
                throw new IllegalStateException("Failed to extract parameter names for " + constructor);
            }
            Parameter[] parameters = constructor.getParameters();
            ArrayList<ConstructorParameter> result = new ArrayList<ConstructorParameter>(parameters.length);
            for (int i = 0; i < parameters.length; ++i) {
                String name = MergedAnnotations.from((AnnotatedElement)parameters[i]).get(Name.class).getValue("value", String.class).orElse(names[i]);
                ResolvableType parameterType = ResolvableType.forMethodParameter((MethodParameter)new MethodParameter(constructor, i), (ResolvableType)type);
                Annotation[] annotations = parameters[i].getDeclaredAnnotations();
                result.add(new ConstructorParameter(name, parameterType, annotations));
            }
            return Collections.unmodifiableList(result);
        }

        @Override
        List<ConstructorParameter> getConstructorParameters() {
            return this.constructorParameters;
        }

        static <T> ValueObject<T> get(Constructor<?> bindConstructor, ResolvableType type) {
            return new DefaultValueObject(bindConstructor, type);
        }
    }
}

